/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatuhc.customitems;

import io.github.greatericontop.greatuhc.GreatUHCMain;
import io.github.greatericontop.greatuhc.customitems.Crafts;
import io.github.greatericontop.greatuhc.util.TrueDamageHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CraftLimiter
implements Listener {
    private Random random = null;
    private List<Material> craftMaterials = null;
    private final Map<String, Map<UUID, Integer>> crafts = new HashMap<String, Map<UUID, Integer>>();
    private final GreatUHCMain plugin;

    public CraftLimiter(GreatUHCMain plugin) {
        this.plugin = plugin;
    }

    public void clearCrafts() {
        this.crafts.clear();
    }

    public void init() {
        this.random = new Random();
        this.craftMaterials = new ArrayList<Material>();
        Bukkit.recipeIterator().forEachRemaining(recipe -> {
            block4: {
                ShapelessRecipe shapelessRecipe;
                block3: {
                    if (!(recipe instanceof ShapedRecipe)) break block3;
                    ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                    if (!shapedRecipe.getKey().getNamespace().equals("uhc")) break block4;
                    for (ItemStack stack : shapedRecipe.getIngredientMap().values()) {
                        if (stack == null) continue;
                        this.craftMaterials.add(stack.getType());
                    }
                    break block4;
                }
                if (recipe instanceof ShapelessRecipe && (shapelessRecipe = (ShapelessRecipe)recipe).getKey().getNamespace().equals("uhc")) {
                    for (ItemStack stack : shapelessRecipe.getIngredientList()) {
                        this.craftMaterials.add(stack.getType());
                    }
                }
            }
        });
    }

    private int findNumberInCraftingTable(CraftItemEvent event) {
        int minNumber = 9999;
        for (ItemStack craftingStack : event.getInventory().getMatrix()) {
            if (craftingStack == null) continue;
            minNumber = Math.min(minNumber, craftingStack.getAmount());
        }
        return minNumber;
    }

    private void handleLimitedCraft(String craftMapKey, CraftItemEvent event, int craftLimit) {
        UUID uuid = event.getWhoClicked().getUniqueId();
        if (!this.crafts.containsKey(craftMapKey)) {
            this.crafts.put(craftMapKey, new HashMap());
        }
        Map<UUID, Integer> craftMap = this.crafts.get(craftMapKey);
        HumanEntity player = event.getWhoClicked();
        switch (event.getClick()) {
            case LEFT: 
            case RIGHT: 
            case DROP: 
            case NUMBER_KEY: {
                int craftsAlready = craftMap.getOrDefault(uuid, 0);
                if (craftsAlready >= craftLimit) {
                    event.setCancelled(true);
                    player.sendMessage(String.format("\u00a7cYou already crafted the limit of \u00a7e%d \u00a7cof this item.", craftLimit));
                    break;
                }
                craftMap.put(uuid, craftsAlready + 1);
                player.sendMessage(String.format("\u00a77You have crafted \u00a7e%d\u00a77/\u00a7e%d \u00a77of this item.", craftsAlready + 1, craftLimit));
                break;
            }
            case SHIFT_LEFT: 
            case SHIFT_RIGHT: 
            case CONTROL_DROP: {
                int craftsAlready = craftMap.getOrDefault(uuid, 0);
                int numberToMake = this.findNumberInCraftingTable(event);
                if (craftsAlready + numberToMake > craftLimit) {
                    event.setCancelled(true);
                    player.sendMessage(String.format("\u00a7cYou have too many items in the crafting table! You can only make \u00a7e%d \u00a7cmore of this item.", craftLimit - craftsAlready));
                    break;
                }
                craftMap.put(uuid, craftsAlready + numberToMake);
                player.sendMessage(String.format("\u00a77You have crafted \u00a7e%d\u00a77/\u00a7e%d \u00a77of this item.", craftsAlready + numberToMake, craftLimit));
                break;
            }
            case DOUBLE_CLICK: {
                player.sendMessage("\u00a7cWe couldn't craft this due to a double click. Try crafting this item again.");
                event.setCancelled(true);
                break;
            }
            case MIDDLE: 
            case SWAP_OFFHAND: 
            case UNKNOWN: 
            case WINDOW_BORDER_LEFT: 
            case WINDOW_BORDER_RIGHT: 
            case CREATIVE: {
                player.sendMessage("\u00a7cWe couldn't craft this. This should never happen, but it did. Try crafting this item again.");
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onCraft(CraftItemEvent event) {
        NamespacedKey key;
        Object object = event.getRecipe();
        if (object instanceof ShapedRecipe) {
            ShapedRecipe recipe = (ShapedRecipe)object;
            key = recipe.getKey();
        } else {
            object = event.getRecipe();
            if (object instanceof ShapelessRecipe) {
                ShapelessRecipe recipe = (ShapelessRecipe)object;
                key = recipe.getKey();
            } else {
                return;
            }
        }
        if (!key.getNamespace().equals("uhc")) {
            return;
        }
        String craftKey = key.getKey();
        switch (craftKey) {
            case "light_apple": {
                this.handleLimitedCraft(craftKey, event, 2);
                break;
            }
            case "sharp_book": {
                this.handleLimitedCraft(craftKey, event, 4);
                break;
            }
            case "apprentice_helmet": {
                this.handleLimitedCraft(craftKey, event, 1);
                break;
            }
            case "tarnhelm": {
                this.handleLimitedCraft(craftKey, event, 1);
                break;
            }
            case "corn": {
                this.handleLimitedCraft(craftKey, event, 1);
                break;
            }
            case "flaming_artifact": {
                this.handleLimitedCraft(craftKey, event, 1);
                break;
            }
            case "nether_blessing": {
                this.handleLimitedCraft(craftKey, event, 1);
                break;
            }
            case "enhancement_book": {
                this.handleLimitedCraft(craftKey, event, 1);
                break;
            }
            case "protection_book": {
                this.handleLimitedCraft(craftKey, event, 4);
                break;
            }
            case "expert_seal": {
                this.handleLimitedCraft(craftKey, event, 1);
                break;
            }
            case "deus_ex_machina": {
                this.handleLimitedCraft(craftKey, event, 1);
                if (event.isCancelled()) break;
                TrueDamageHelper.dealTrueDamage((LivingEntity)event.getWhoClicked(), event.getWhoClicked().getHealth() * 0.5);
                break;
            }
            case "chest_of_fate": {
                this.handleLimitedCraft(craftKey, event, 1);
                if (!(Math.random() < 0.5) || event.isCancelled()) break;
                final Player player = (Player)event.getWhoClicked();
                event.getInventory().setResult(new ItemStack(Material.COAL, 2));
                new BukkitRunnable(){

                    public void run() {
                        TrueDamageHelper.dealTrueDamage((LivingEntity)player, 20.0);
                        player.getWorld().strikeLightningEffect(player.getLocation());
                    }
                }.runTaskLater((Plugin)this.plugin, 1L);
                break;
            }
            case "holy_water": {
                this.handleLimitedCraft(craftKey, event, 3);
                break;
            }
            case "philosopher_pickaxe": {
                this.handleLimitedCraft(craftKey, event, 2);
                break;
            }
            case "arrow_economy": {
                this.handleLimitedCraft(craftKey, event, 3);
                break;
            }
            case "death_scythe": {
                this.handleLimitedCraft(craftKey, event, 1);
                break;
            }
            case "golden_head": {
                this.handleLimitedCraft(craftKey, event, 2);
                break;
            }
            case "book_of_thoth": {
                this.handleLimitedCraft(craftKey, event, 1);
                break;
            }
            case "power_book": {
                this.handleLimitedCraft(craftKey, event, 3);
                break;
            }
            case "apple_economy": {
                this.handleLimitedCraft(craftKey, event, 3);
                break;
            }
            case "apprentice_sword": {
                this.handleLimitedCraft(craftKey, event, 1);
                break;
            }
            case "dice_of_god": {
                if (event.getClick() != ClickType.LEFT && event.getClick() != ClickType.RIGHT) {
                    event.getWhoClicked().sendMessage("\u00a7cYou can only craft this item by left or right clicking.");
                    event.setCancelled(true);
                    return;
                }
                if (event.getWhoClicked().getItemOnCursor().getType() != Material.AIR) {
                    event.getWhoClicked().sendMessage("\u00a7cThere can't be an item already on your cursor!");
                    event.setCancelled(true);
                    return;
                }
                this.handleLimitedCraft(craftKey, event, this.plugin.uhcFateKit ? 1000 : 1);
                if (event.isCancelled()) break;
                ItemStack ultimate = Crafts.getRandomUltimate();
                event.getInventory().setResult(ultimate);
                event.getWhoClicked().sendMessage(((TextComponent)Component.text((String)"\u00a7aYou received ").append(ultimate.getItemMeta().displayName())).append((Component)Component.text((String)"\u00a7a.")));
                break;
            }
            case "velocity_potion": {
                this.handleLimitedCraft(craftKey, event, 3);
                break;
            }
            case "nectar": {
                this.handleLimitedCraft(craftKey, event, 3);
                break;
            }
            case "backpack": {
                this.handleLimitedCraft(craftKey, event, 1);
                break;
            }
            case "sugar_cookie": {
                this.handleLimitedCraft(craftKey, event, 3);
                break;
            }
            case "apprentice_bow": {
                this.handleLimitedCraft(craftKey, event, 1);
                break;
            }
            case "vitality_potion": {
                this.handleLimitedCraft(craftKey, event, 1);
                break;
            }
            case "toughness_potion": {
                this.handleLimitedCraft(craftKey, event, 1);
                break;
            }
            case "delicious_meal": {
                this.handleLimitedCraft(craftKey, event, 3);
                break;
            }
            case "glass_economy": {
                this.handleLimitedCraft(craftKey, event, 3);
                break;
            }
            case "fate_temptation": {
                Player player = (Player)event.getWhoClicked();
                if (!player.getLocation().getBlock().getType().isAir()) {
                    player.sendMessage("\u00a7cThe block you're currently in must be air!");
                    event.setCancelled(true);
                    return;
                }
                this.handleLimitedCraft(craftKey, event, 1);
                if (event.isCancelled()) break;
                Block chestBlock = player.getLocation().getBlock();
                chestBlock.setType(Material.CHEST, false);
                Chest chest = (Chest)chestBlock.getState();
                Inventory inv = chest.getInventory();
                for (int i = 10; i <= 16; ++i) {
                    Material mat = this.craftMaterials.get(this.random.nextInt(this.craftMaterials.size()));
                    inv.setItem(i, new ItemStack(mat, 1));
                }
                break;
            }
            case "sugar_economy": {
                this.handleLimitedCraft(craftKey, event, 3);
                break;
            }
            case "obsidian": {
                this.handleLimitedCraft(craftKey, event, 1);
                break;
            }
            case "flask_of_ichor": {
                this.handleLimitedCraft(craftKey, event, 1);
            }
        }
    }
}

