/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatuhc;

import io.github.greatericontop.greatuhc.GreatUHCMain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.util.StringUtil;

public class GreatUHCCommand
implements CommandExecutor,
TabCompleter {
    private final GreatUHCMain plugin;

    public GreatUHCCommand(GreatUHCMain plugin) {
        this.plugin = plugin;
    }

    private Component generateMsg(String modName, boolean state, String command) {
        return Component.text((String)String.format("\u00a7e%s\u00a77: \u00a7f[%s\u00a7f]  ", modName, state ? "\u00a72ON" : "\u00a74OFF")).append(((TextComponent)Component.text((String)"\u00a77[toggle]").clickEvent(ClickEvent.runCommand((String)String.format("/greatuhc %s", command)))).hoverEvent((HoverEventSource)Component.text((String)"\u00a77Click to toggle this modifier.")));
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage("\u00a79--------------------------------------------------");
            sender.sendMessage("\u00a73GreatUHC by greateric");
            sender.sendMessage("");
            sender.sendMessage(this.generateMsg("Double Heads", this.plugin.uhcDoubleHeads, "double-heads"));
            sender.sendMessage(this.generateMsg("Powerful Heads", this.plugin.uhcPowerfulHeads, "powerful-heads"));
            sender.sendMessage(this.generateMsg("Survivalism", this.plugin.uhcSurvivalism, "survivalism"));
            sender.sendMessage(this.generateMsg("Mining Modifier", this.plugin.uhcMiningModifier, "mining-modifier"));
            sender.sendMessage(this.generateMsg("Starting Heads", this.plugin.uhcStartingHeads, "starting-heads"));
            sender.sendMessage(this.generateMsg("Random Ultimate", this.plugin.uhcRandomUltimate, "random-ultimate"));
            sender.sendMessage("");
            sender.sendMessage(this.generateMsg("All Drop Stone", this.plugin.uhcAllDropStone, "drop-stone"));
            sender.sendMessage(this.generateMsg("Fast Reflexes", this.plugin.uhcFastReflexes, "fast-reflexes"));
            sender.sendMessage(this.generateMsg("Fate Kit", this.plugin.uhcFateKit, "fate-kit"));
            sender.sendMessage(this.generateMsg("Enhanced Kits", this.plugin.uhcEnhancedKits, "enhanced-kits"));
            sender.sendMessage("");
            sender.sendMessage(this.generateMsg("Debug Mode", this.plugin.debugMode, "debug-mode"));
            sender.sendMessage("");
            sender.sendMessage(Component.text((String)"\u00a7b[Clear Crafts]").clickEvent(ClickEvent.runCommand((String)"/greatuhc crafts")));
            sender.sendMessage(Component.text((String)"\u00a7b[Reload Config]").clickEvent(ClickEvent.runCommand((String)"/greatuhc reload")));
            sender.sendMessage(Component.text((String)"\u00a7b[Extend Clock]").clickEvent(ClickEvent.suggestCommand((String)"/greatuhc extend-clock ")));
            sender.sendMessage("");
            sender.sendMessage("\u00a79--------------------------------------------------");
            return true;
        }
        if (args[0].equals("crafts")) {
            this.plugin.craftLimiter.clearCrafts();
            sender.sendMessage("\u00a7aCrafts cleared!");
            return true;
        }
        if (args[0].equals("reload")) {
            this.plugin.reloadConfig();
            sender.sendMessage("\u00a7aConfig reloaded!");
            return true;
        }
        if (args[0].equals("extend-clock")) {
            int seconds;
            if (args.length == 1) {
                seconds = 30;
            } else {
                try {
                    seconds = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage("\u00a7cInvalid number!");
                    return true;
                }
            }
            this.plugin.gameManager.extend(seconds);
            Bukkit.broadcastMessage((String)String.format("\u00a7aThe clock was extended by %d seconds!", seconds));
            return true;
        }
        if (args[0].equals("double-heads")) {
            this.plugin.uhcDoubleHeads = !this.plugin.uhcDoubleHeads;
            sender.sendMessage(String.format("\u00a7cDouble Heads \u00a73is now %s", this.plugin.uhcDoubleHeads ? "\u00a72ON" : "\u00a74OFF"));
            return true;
        }
        if (args[0].equals("powerful-heads")) {
            this.plugin.uhcPowerfulHeads = !this.plugin.uhcPowerfulHeads;
            sender.sendMessage(String.format("\u00a7cPowerful Heads \u00a73is now %s", this.plugin.uhcPowerfulHeads ? "\u00a72ON" : "\u00a74OFF"));
            return true;
        }
        if (args[0].equals("survivalism")) {
            this.plugin.uhcSurvivalism = !this.plugin.uhcSurvivalism;
            sender.sendMessage(String.format("\u00a7cSurvivalism \u00a73is now %s", this.plugin.uhcSurvivalism ? "\u00a72ON" : "\u00a74OFF"));
            return true;
        }
        if (args[0].equals("mining-modifier")) {
            this.plugin.uhcMiningModifier = !this.plugin.uhcMiningModifier;
            sender.sendMessage(String.format("\u00a7cMining Modifier \u00a73is now %s", this.plugin.uhcMiningModifier ? "\u00a72ON" : "\u00a74OFF"));
            return true;
        }
        if (args[0].equals("debug-mode")) {
            this.plugin.debugMode = !this.plugin.debugMode;
            sender.sendMessage(String.format("\u00a7cDebug Mode \u00a73is now %s", this.plugin.debugMode ? "\u00a72ON" : "\u00a74OFF"));
            return true;
        }
        if (args[0].equals("starting-heads")) {
            this.plugin.uhcStartingHeads = !this.plugin.uhcStartingHeads;
            sender.sendMessage(String.format("\u00a7cStarting Heads \u00a73is now %s", this.plugin.uhcStartingHeads ? "\u00a72ON" : "\u00a74OFF"));
            return true;
        }
        if (args[0].equals("random-ultimate")) {
            this.plugin.uhcRandomUltimate = !this.plugin.uhcRandomUltimate;
            sender.sendMessage(String.format("\u00a7cRandom Ultimate \u00a73is now %s", this.plugin.uhcRandomUltimate ? "\u00a72ON" : "\u00a74OFF"));
            return true;
        }
        if (args[0].equals("all-drop-stone")) {
            this.plugin.uhcAllDropStone = !this.plugin.uhcAllDropStone;
            sender.sendMessage(String.format("\u00a7cAll Drop Stone \u00a73is now %s", this.plugin.uhcAllDropStone ? "\u00a72ON" : "\u00a74OFF"));
            return true;
        }
        if (args[0].equals("fast-reflexes")) {
            this.plugin.uhcFastReflexes = !this.plugin.uhcFastReflexes;
            sender.sendMessage(String.format("\u00a7cFast Reflexes \u00a73is now %s", this.plugin.uhcFastReflexes ? "\u00a72ON" : "\u00a74OFF"));
            return true;
        }
        if (args[0].equals("fate-kit")) {
            this.plugin.uhcFateKit = !this.plugin.uhcFateKit;
            sender.sendMessage(String.format("\u00a7cFate Kit \u00a73is now %s", this.plugin.uhcFateKit ? "\u00a72ON" : "\u00a74OFF"));
            return true;
        }
        if (args[0].equals("enhanced-kits")) {
            this.plugin.uhcEnhancedKits = !this.plugin.uhcEnhancedKits;
            sender.sendMessage(String.format("\u00a7cEnhanced Kits \u00a73is now %s", this.plugin.uhcEnhancedKits ? "\u00a72ON" : "\u00a74OFF"));
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            List<String> mainCommands = Arrays.asList("crafts", "reload", "extend-clock", "double-heads", "powerful-heads", "survivalism", "mining-modifier", "starting-heads", "random-ultimate", "all-drop-stone", "fast-reflexes", "fate-kit", "enhanced-kits", "debug-mode");
            return (List)StringUtil.copyPartialMatches((String)args[0], mainCommands, new ArrayList(mainCommands.size()));
        }
        if (args.length == 2 && args[0].equals("extend-clock")) {
            return List.of("<seconds>");
        }
        return null;
    }
}

