/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatuhc;

import io.github.greatericontop.greatuhc.GreatUHCMain;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;

public class FightingDisplay
implements Listener {
    private int clock;
    private final Map<Player, Player> targets = new HashMap<Player, Player>();
    private final Map<Player, Integer> expiry = new HashMap<Player, Integer>();
    private final GreatUHCMain plugin;

    public FightingDisplay(GreatUHCMain plugin) {
        this.plugin = plugin;
        this.clock = 0;
        new BukkitRunnable(){

            public void run() {
                ++FightingDisplay.this.clock;
            }
        }.runTaskTimer((Plugin)plugin, 5L, 5L);
    }

    public String getInformation(Player player) {
        Player target = this.targets.get(player);
        if (target == null) {
            return null;
        }
        if (this.expiry.get(player) < this.clock || target.isDead()) {
            this.targets.remove(player);
            this.expiry.remove(player);
            return null;
        }
        return String.format("\u00a7e%s \u00a7f- \u00a7c%.0f \u00a7fHP", target.getDisplayName(), target.getHealth() + target.getAbsorptionAmount());
    }

    private void doFightingDisplay(Player attacker, Player victim) {
        this.targets.put(attacker, victim);
        this.expiry.put(attacker, this.clock + 32);
    }

    @EventHandler
    public void onDamageByEntityPlayer(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity;
        Entity entity2 = event.getEntity();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player victim = (Player)entity2;
        this.doFightingDisplay(attacker, victim);
    }

    @EventHandler
    public void onDamageByEntityProjectile(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (!(entity instanceof Projectile)) {
            return;
        }
        Projectile projectile = (Projectile)entity;
        ProjectileSource projectileSource = projectile.getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player shooter = (Player)projectileSource;
        Entity entity2 = event.getEntity();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player victim = (Player)entity2;
        this.doFightingDisplay(shooter, victim);
    }
}

