/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor.utils;

import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;

public record PartialCoordinates(double x, double y, double z, double yaw) {
    public static PartialCoordinates fromConfigEntry(List<Double> configEntry) {
        if (configEntry.size() == 3) {
            return new PartialCoordinates(configEntry.get(0), configEntry.get(1), configEntry.get(2), 0.0);
        }
        if (configEntry.size() == 4) {
            return new PartialCoordinates(configEntry.get(0), configEntry.get(1), configEntry.get(2), configEntry.get(3));
        }
        throw new IllegalArgumentException("Config entry must contain 3 or 4 values (x, y, z, optional yaw)");
    }

    public static PartialCoordinates ofLocation(Location loc) {
        return new PartialCoordinates(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw());
    }

    public boolean isClose(PartialCoordinates other) {
        return Math.abs(this.x - other.x) < 0.8 && Math.abs(this.y - other.y) < 1.0 && Math.abs(this.z - other.z) < 0.8;
    }

    public Location teleportLocation(World world) {
        return new Location(world, this.x, this.y, this.z, (float)this.yaw, 0.0f);
    }
}

