/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor.task.sabotage;

import io.github.greatericontop.greatimpostor.GreatImpostorMain;
import io.github.greatericontop.greatimpostor.core.profiles.ImpostorProfile;
import io.github.greatericontop.greatimpostor.core.profiles.PlayerProfile;
import io.github.greatericontop.greatimpostor.task.TaskUtil;
import io.github.greatericontop.greatimpostor.task.sabotage.Sabotage;
import io.github.greatericontop.greatimpostor.task.sabotage.SabotageSubtask;
import io.github.greatericontop.greatimpostor.utils.CooldownResetReason;
import java.time.Duration;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SabotageManager
implements Listener {
    private Sabotage activeSabotage = null;
    private ImpostorProfile responsibleImpostor = null;
    private int criticalCountdown = -1;
    private final GreatImpostorMain plugin;

    public SabotageManager(GreatImpostorMain plugin) {
        this.plugin = plugin;
    }

    public Sabotage getActiveSabotage() {
        return this.activeSabotage;
    }

    public boolean isSabotageActive() {
        return this.activeSabotage != null;
    }

    public boolean isDisruptiveSabotageActive() {
        return this.isSabotageActive() && this.activeSabotage.disruptsGame();
    }

    public boolean shouldRemoveWhenBodyReported() {
        return this.isSabotageActive() && (this.activeSabotage == Sabotage.REACTOR || this.activeSabotage == Sabotage.OXYGEN);
    }

    @EventHandler
    public void onHotkey(PlayerItemHeldEvent event) {
        int newSlot = event.getNewSlot();
        PlayerProfile profile = this.plugin.playerProfiles.get(event.getPlayer().getUniqueId());
        if (profile == null) {
            return;
        }
        if (!profile.isImpostor()) {
            return;
        }
        if (newSlot == 5) {
            this.cycleSabotage((ImpostorProfile)profile);
            event.setCancelled(true);
        } else if (newSlot == 6) {
            this.activateSabotage((ImpostorProfile)profile);
            event.setCancelled(true);
        }
    }

    public void cycleSabotage(ImpostorProfile playerProfile) {
        Sabotage cur = playerProfile.selectedSabotage;
        playerProfile.selectedSabotage = Sabotage.values()[(cur.ordinal() + 1) % Sabotage.values().length];
    }

    public void activateSabotage(ImpostorProfile playerProfile) {
        Player player = playerProfile.getPlayer();
        if (this.isSabotageActive()) {
            player.sendMessage("\u00a7cThere is already a sabotage active!");
            return;
        }
        if (!playerProfile.getCanSabotage()) {
            player.sendMessage("\u00a7cYou can't sabotage right now!");
            return;
        }
        this.activeSabotage = playerProfile.selectedSabotage;
        this.responsibleImpostor = playerProfile;
        this.criticalCountdown = this.plugin.getConfig().getInt("critical-sabotage-fix-ticks");
        TaskUtil.getSabotageTaskClass(this.plugin, this.activeSabotage).prepareSabotageTask();
        player.sendMessage(String.format("\u00a76You activated \u00a7c%s\u00a76.", this.activeSabotage.getDisplayName()));
        if (this.activeSabotage == Sabotage.COMMUNICATIONS) {
            this.plugin.gameManager.requestInventoryChange();
        }
    }

    public void endSabotage(Sabotage sabotageType) {
        if (this.activeSabotage == sabotageType) {
            this.forceEndSabotage();
        }
    }

    public void forceEndSabotage() {
        if (this.activeSabotage == Sabotage.COMMUNICATIONS) {
            this.plugin.gameManager.requestInventoryChange();
        }
        this.activeSabotage = null;
        this.plugin.gameManager.resetAllSabotageCooldowns(CooldownResetReason.AFTER_USE);
    }

    public void tickSabotages() {
        if (!this.isSabotageActive()) {
            return;
        }
        if (this.activeSabotage.isCritical()) {
            --this.criticalCountdown;
            int seconds = this.criticalCountdown / 20;
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.showTitle(Title.title((Component)Component.text((String)String.format("\u00a7c%s", this.activeSabotage.getDisplayName())), (Component)Component.text((String)String.format("\u00a77%s", seconds)), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(0L), (Duration)Duration.ofMillis(200L), (Duration)Duration.ofMillis(1000L))));
                if (this.criticalCountdown % 40 != 0) continue;
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 0.8f, 0.5f);
            }
            if (this.criticalCountdown <= 0) {
                this.forceEndSabotage();
                this.plugin.gameManager.endGame("\u00a7cImpostors win! \u00a7aThe sabotage caused the crew to die!");
                return;
            }
        }
        SabotageSubtask[] requiredSubtasks = this.activeSabotage.getRequiredSubtasks(this.plugin);
        if (this.plugin.getClock() % 40 == 0) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (player.getGameMode() == GameMode.SPECTATOR) continue;
                for (SabotageSubtask st : requiredSubtasks) {
                    this.plugin.pathfindingHelperListener.showSabotagePath(player, st);
                }
            }
        }
        switch (this.activeSabotage) {
            case REACTOR: 
            case OXYGEN: {
                break;
            }
            case LIGHTS: {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    PlayerProfile profile = this.plugin.playerProfiles.get(player.getUniqueId());
                    if (profile == null) continue;
                    if (!profile.isImpostor()) {
                        player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 39, 0));
                    }
                    player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 5, 0));
                }
                break;
            }
        }
    }
}

