/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor.task.maintaskexecutors;

import io.github.greatericontop.greatimpostor.GreatImpostorMain;
import io.github.greatericontop.greatimpostor.task.BaseTask;
import io.github.greatericontop.greatimpostor.task.TaskType;
import io.github.greatericontop.greatimpostor.utils.ItemMaker;
import io.github.greatericontop.greatimpostor.utils.Shuffler;
import java.util.Map;
import java.util.Random;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class TaskWiring
extends BaseTask {
    public static final String INVENTORY_NAME = "\u00a7aAmong Us - Fix Wiring";
    private static final Map<Material, String> COLOR_NAMES = Map.of(Material.RED_WOOL, "\u00a7cRED", Material.ORANGE_WOOL, "\u00a76ORANGE", Material.YELLOW_WOOL, "\u00a7eYELLOW", Material.LIME_WOOL, "\u00a7aGREEN", Material.CYAN_WOOL, "\u00a7aCYAN", Material.PURPLE_WOOL, "\u00a75PURPLE");

    public TaskWiring(GreatImpostorMain plugin) {
        super(plugin);
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.WIRING;
    }

    @Override
    public void startTask(Player player) {
        Random random = new Random();
        Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)54, (Component)Component.text((String)INVENTORY_NAME));
        Object[] materials = new Material[]{Material.RED_WOOL, Material.ORANGE_WOOL, Material.YELLOW_WOOL, Material.LIME_WOOL, Material.CYAN_WOOL, Material.PURPLE_WOOL};
        Shuffler.shuffle(materials, random);
        Object[] targetMaterials = new Material[]{Material.RED_WOOL, Material.ORANGE_WOOL, Material.YELLOW_WOOL, Material.LIME_WOOL, Material.CYAN_WOOL, Material.PURPLE_WOOL};
        Shuffler.shuffle(targetMaterials, random);
        for (int i = 0; i < 6; ++i) {
            ItemStack stack = ItemMaker.createStack((Material)targetMaterials[i], 1, "\u00a7eIn order, click the colored blocks on the right.", String.format("\u00a77Click %s \u00a77on the right side", COLOR_NAMES.get(targetMaterials[0])));
            if (i == 0) {
                stack.addUnsafeEnchantment(Enchantment.LUCK, 1);
            }
            gui.setItem(i * 9, stack);
            gui.setItem(i * 9 + 8, new ItemStack((Material)materials[i], 1));
            for (int j = 1; j < 8; ++j) {
                gui.setItem(i * 9 + j, new ItemStack(Material.GRAY_STAINED_GLASS_PANE, 1));
            }
        }
        player.openInventory(gui);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getView().getTitle().equals(INVENTORY_NAME)) {
            return;
        }
        event.setCancelled(true);
        if (!event.getClickedInventory().equals(event.getView().getTopInventory())) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        int currentSourceSlot = 0;
        for (int i = 0; i < 45 && event.getClickedInventory().getItem(i).getType() == Material.LIME_STAINED_GLASS; i += 9) {
            currentSourceSlot = i + 9;
        }
        int slot = event.getSlot();
        if (event.getClickedInventory().getItem(slot).getType() == event.getClickedInventory().getItem(currentSourceSlot).getType() && slot != currentSourceSlot) {
            this.playSuccessSound(player);
            event.getClickedInventory().setItem(currentSourceSlot, ItemMaker.createStack(Material.LIME_STAINED_GLASS, 1, "\u00a7aDone!", new String[0]));
            if (currentSourceSlot == 45) {
                this.taskSuccessful(player);
                player.closeInventory();
            } else {
                Inventory inv = event.getClickedInventory();
                Material nextMat = inv.getItem(currentSourceSlot + 9).getType();
                for (int i = currentSourceSlot + 9; i <= 45; i += 9) {
                    ItemStack stack = ItemMaker.createStack(inv.getItem(i).getType(), 1, "\u00a7eIn order, click the colored blocks on the right.", String.format("\u00a77Click %s \u00a77on the right side", COLOR_NAMES.get(nextMat)));
                    if (i == currentSourceSlot + 9) {
                        stack.addUnsafeEnchantment(Enchantment.LUCK, 1);
                    }
                    inv.setItem(i, stack);
                }
            }
        } else {
            this.playFailSound(player);
            player.sendMessage("\u00a7cYou failed!");
            player.closeInventory();
        }
    }
}

