/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor.task.maintaskexecutors;

import io.github.greatericontop.greatimpostor.GreatImpostorMain;
import io.github.greatericontop.greatimpostor.task.BaseTask;
import io.github.greatericontop.greatimpostor.task.TaskType;
import io.github.greatericontop.greatimpostor.utils.Shuffler;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TaskUnlockManifolds
extends BaseTask {
    public static final String INVENTORY_NAME = "\u00a7aAmong Us - Unlock Manifolds";
    private final Map<UUID, Integer> currentNumber = new HashMap<UUID, Integer>();

    public TaskUnlockManifolds(GreatImpostorMain plugin) {
        super(plugin);
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.UNLOCK_MANIFOLDS;
    }

    @Override
    public void startTask(Player player) {
        Random random = new Random();
        Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)36, (Component)Component.text((String)INVENTORY_NAME));
        Object[] inventorySlots = new Integer[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25};
        Shuffler.shuffle(inventorySlots, random);
        for (int i = 0; i < 14; ++i) {
            Material mat = (Integer)inventorySlots[i] % 2 == 0 ? Material.BLUE_STAINED_GLASS_PANE : Material.LIGHT_BLUE_STAINED_GLASS_PANE;
            ItemStack stack = new ItemStack(mat, i + 1);
            ItemMeta im = stack.getItemMeta();
            im.displayName((Component)Component.text((String)String.format("\u00a7e%d", i + 1)));
            stack.setItemMeta(im);
            gui.setItem(((Integer)inventorySlots[i]).intValue(), stack);
        }
        this.currentNumber.put(player.getUniqueId(), 1);
        player.openInventory(gui);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getView().getTitle().equals(INVENTORY_NAME)) {
            return;
        }
        event.setCancelled(true);
        if (!event.getClickedInventory().equals(event.getView().getTopInventory())) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ItemStack clickedOn = event.getCurrentItem();
        if (clickedOn == null) {
            return;
        }
        int numberClickedOn = clickedOn.getAmount();
        if (numberClickedOn != this.currentNumber.get(player.getUniqueId())) {
            this.playFailSound(player);
            player.sendMessage("\u00a7cYou clicked the wrong button!");
            player.closeInventory();
            return;
        }
        this.playSuccessSound(player);
        if (numberClickedOn == 14) {
            this.taskSuccessful(player);
            player.closeInventory();
        } else {
            this.currentNumber.put(player.getUniqueId(), numberClickedOn + 1);
            clickedOn.setType(Material.LIME_STAINED_GLASS_PANE);
        }
    }
}

