/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor.task.maintaskexecutors;

import io.github.greatericontop.greatimpostor.GreatImpostorMain;
import io.github.greatericontop.greatimpostor.task.BaseTask;
import io.github.greatericontop.greatimpostor.task.TaskType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TaskSwipeCard
extends BaseTask {
    public static final String INVENTORY_NAME = "\u00a7aAmong Us - Swipe Card";
    private static final int OFFSET = 10;
    private static final double CONSISTENCY_FACTOR = 1.6;
    private final Map<UUID, List<Integer>> cardSwipeData = new HashMap<UUID, List<Integer>>();

    public TaskSwipeCard(GreatImpostorMain plugin) {
        super(plugin);
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.SWIPE_CARD;
    }

    @Override
    public void startTask(Player player) {
        Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)18, (Component)Component.text((String)INVENTORY_NAME));
        ItemStack info = new ItemStack(Material.WHITE_STAINED_GLASS, 1);
        ItemMeta im = info.getItemMeta();
        im.displayName((Component)Component.text((String)"\u00a7aSwipe Card"));
        im.lore(List.of(Component.text((String)"\u00a77You need to swipe the card."), Component.text((String)"\u00a77Click each of the glass panes from left to right."), Component.text((String)"\u00a77Don't go too fast or too slow, and stay consistent.")));
        info.setItemMeta(im);
        gui.setItem(4, info);
        for (int i = 10; i < 17; ++i) {
            gui.setItem(i, new ItemStack(Material.CYAN_STAINED_GLASS_PANE, 1));
        }
        this.cardSwipeData.put(player.getUniqueId(), Arrays.asList(-2, -2, -2, -2, -2, -2, -2));
        player.openInventory(gui);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getView().getTitle().equals(INVENTORY_NAME)) {
            return;
        }
        event.setCancelled(true);
        if (!event.getClickedInventory().equals(event.getView().getTopInventory())) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        int numberClicked = event.getSlot() - 10;
        if (numberClicked < 0 || numberClicked >= 7) {
            return;
        }
        List<Integer> data = this.cardSwipeData.get(player.getUniqueId());
        if (data.get(numberClicked) != -2 || numberClicked != 0 && data.get(numberClicked - 1) == -2) {
            this.playFailSound(player);
            player.sendMessage("\u00a7cYou clicked in the wrong order!");
            return;
        }
        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.0f);
        data.set(numberClicked, this.plugin.getClock());
        if (numberClicked == 6) {
            int[] deltas = this.getDeltas(data);
            double accuracy = Math.sqrt(this.getVariance(deltas, 5.0));
            double mean = (double)(deltas[0] + deltas[1] + deltas[2] + deltas[3] + deltas[4] + deltas[5]) / 6.0;
            double consistency = Math.sqrt(this.getVariance(deltas, mean));
            double score = accuracy + 1.6 * consistency;
            player.sendMessage(String.format("\u00a77accuracy \u00a7f%.2f \u00a77consistency \u00a7f%.2f \u00a77(mean %.2f)  \u00a77|  SCORE: \u00a7e%.2f", accuracy, consistency, mean, score));
            if (score < 7.0) {
                this.playSuccessSound(player);
                this.taskSuccessful(player);
                player.closeInventory();
            } else {
                this.playFailSound(player);
                player.closeInventory();
                player.sendMessage("\u00a7cCouldn't read the card! Try again!");
                if (mean >= 5.7) {
                    player.sendMessage("\u00a7cYou were too slow!");
                } else if (mean <= 4.3) {
                    player.sendMessage("\u00a7cYou were too fast!");
                } else if (1.6 * consistency >= 4.5) {
                    player.sendMessage("\u00a7cYou were not very consistent.");
                } else {
                    player.sendMessage("\u00a7cYou were close. Try again!");
                }
            }
        }
    }

    private int[] getDeltas(List<Integer> data) {
        int[] deltas = new int[6];
        for (int i = 0; i < 6; ++i) {
            deltas[i] = data.get(i + 1) - data.get(i);
        }
        return deltas;
    }

    private double getVariance(int[] deltas, double targetValue) {
        double variance = 0.0;
        for (int i = 0; i < 6; ++i) {
            variance += ((double)deltas[i] - targetValue) * ((double)deltas[i] - targetValue);
        }
        return variance;
    }
}

