/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor.task.maintaskexecutors;

import io.github.greatericontop.greatimpostor.GreatImpostorMain;
import io.github.greatericontop.greatimpostor.core.profiles.PlayerProfile;
import io.github.greatericontop.greatimpostor.task.BaseTask;
import io.github.greatericontop.greatimpostor.task.TaskType;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TaskSubmitScan
extends BaseTask {
    public TaskSubmitScan(GreatImpostorMain plugin) {
        super(plugin);
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.SUBMIT_SCAN;
    }

    @Override
    public void startTask(final Player player) {
        PlayerProfile profile = this.plugin.playerProfiles.get(player.getUniqueId());
        if (profile == null) {
            player.sendMessage("\u00a7cCouldn't get your profile! This should never happen.");
            return;
        }
        if (profile.isImpostor()) {
            player.sendMessage("\u00a7cYou can't submit a scan if you're an impostor!");
            return;
        }
        final Location playerLocation = player.getLocation();
        player.sendMessage("\u00a73Starting scan, please don't move...");
        new BukkitRunnable(){
            int tickNum = 0;

            public void run() {
                ++this.tickNum;
                if (this.tickNum == 240) {
                    TaskSubmitScan.this.playSuccessSound(player);
                    TaskSubmitScan.this.taskSuccessful(player);
                    this.cancel();
                    return;
                }
                if (this.tickNum % 15 == 0) {
                    int i = this.tickNum / 15;
                    double yOffset = i > 8 ? 2.0 - (double)(i - 8) * 0.25 : (double)i * 0.25;
                    int DIVISIONS = 60;
                    for (int angle = 0; angle < 60; ++angle) {
                        double radians = (double)(angle * 2) * Math.PI / 60.0;
                        double xOffset = Math.cos(radians) * 0.9;
                        double zOffset = Math.sin(radians) * 0.9;
                        player.getWorld().spawnParticle(Particle.VILLAGER_HAPPY, playerLocation.clone().add(xOffset, yOffset, zOffset), 1, 0.0, 0.0, 0.0);
                    }
                }
                if (player.getLocation().distanceSquared(playerLocation) >= 0.01) {
                    player.sendMessage("\u00a7cPlease don't move while you're being scanned!");
                    TaskSubmitScan.this.playFailSound(player);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }
}

