/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor.task.maintaskexecutors;

import io.github.greatericontop.greatimpostor.GreatImpostorMain;
import io.github.greatericontop.greatimpostor.task.BaseTask;
import io.github.greatericontop.greatimpostor.task.TaskType;
import io.github.greatericontop.greatimpostor.utils.ItemMaker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TaskStartReactor
extends BaseTask {
    public static final String INVENTORY_NAME = "\u00a7aAmong Us - Start Reactor";
    private static final float[] PITCHES = new float[]{0.707107f, 0.793701f, 0.890899f, 0.943874f, 1.059463f};
    private static final Material[] MATERIALS = new Material[]{Material.RED_WOOL, Material.BLUE_WOOL, Material.LIME_WOOL, Material.YELLOW_WOOL, Material.WHITE_WOOL};
    private static final int DISPLAY_OFFSET = 1;
    private static final int KEY_OFFSET = 29;
    private final Map<Player, ArrayList<Integer>> playerPasswordMap = new HashMap<Player, ArrayList<Integer>>();
    private final Map<Player, Integer> playerDigitCount = new HashMap<Player, Integer>();
    private final Map<Player, Boolean> cooldown = new HashMap<Player, Boolean>();

    public TaskStartReactor(GreatImpostorMain plugin) {
        super(plugin);
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.START_REACTOR;
    }

    @Override
    public void startTask(Player player) {
        int i;
        int i2;
        Random random = new Random();
        Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)54, (Component)Component.text((String)INVENTORY_NAME));
        ArrayList<Integer> password = new ArrayList<Integer>();
        for (i2 = 0; i2 < 7; ++i2) {
            password.add(random.nextInt(MATERIALS.length));
        }
        this.playerPasswordMap.put(player, password);
        this.playerDigitCount.put(player, 1);
        for (i2 = 0; i2 < MATERIALS.length; ++i2) {
            gui.setItem(29 + i2, ItemMaker.createStack(MATERIALS[i2], 1, "\u00a7eClick on this to enter the sequence.", new String[0]));
        }
        for (i2 = 0; i2 < 7; ++i2) {
            gui.setItem(1 + i2, this.blackGlassStack());
        }
        ItemStack sequenceItemStack = ItemMaker.createStack(MATERIALS[(Integer)password.get(0)], 1, "\u00a73Memorize the sequence and enter it below.", new String[0]);
        gui.setItem(1, sequenceItemStack);
        gui.setItem(0, new ItemStack(Material.NETHER_STAR, 1));
        gui.setItem(8, new ItemStack(Material.NETHER_STAR, 1));
        for (i = 19; i <= 25; ++i) {
            gui.setItem(i, new ItemStack(Material.GRAY_STAINED_GLASS_PANE, 1));
        }
        gui.setItem(28, new ItemStack(Material.GRAY_STAINED_GLASS_PANE, 1));
        gui.setItem(34, new ItemStack(Material.GRAY_STAINED_GLASS_PANE, 1));
        for (i = 37; i <= 43; ++i) {
            gui.setItem(i, new ItemStack(Material.GRAY_STAINED_GLASS_PANE, 1));
        }
        player.openInventory(gui);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        int i;
        if (!event.getView().getTitle().equals(INVENTORY_NAME)) {
            return;
        }
        event.setCancelled(true);
        if (!event.getClickedInventory().equals(event.getView().getTopInventory())) {
            return;
        }
        final Player player = (Player)event.getWhoClicked();
        if (event.getCurrentItem() == null) {
            return;
        }
        Material mat = event.getCurrentItem().getType();
        if (mat == Material.GRAY_STAINED_GLASS_PANE) {
            return;
        }
        int indexClicked = event.getSlot() - 29;
        if (indexClicked < 0 || indexClicked >= 5) {
            return;
        }
        Inventory inv = event.getInventory();
        if (this.cooldown.getOrDefault(player, false).booleanValue()) {
            player.sendMessage("\u00a7cClicking too fast!");
            return;
        }
        this.cooldown.put(player, true);
        new BukkitRunnable(){

            public void run() {
                TaskStartReactor.this.cooldown.put(player, false);
            }
        }.runTaskLater((Plugin)this.plugin, 3L);
        int currentDigitIndex = -1;
        for (i = 0; i < 7; ++i) {
            if (inv.getItem(1 + i).getType() == Material.GREEN_STAINED_GLASS) continue;
            currentDigitIndex = i;
            break;
        }
        player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, PITCHES[indexClicked]);
        if (indexClicked != this.playerPasswordMap.get(player).get(currentDigitIndex)) {
            this.playFailSound(player);
            player.sendMessage("\u00a7cIncorrect code!");
            player.closeInventory();
            return;
        }
        if (currentDigitIndex == this.playerDigitCount.get(player) - 1) {
            int i2;
            this.playSuccessSound(player);
            int newDigitCount = this.playerDigitCount.get(player) + 1;
            if (newDigitCount == 8) {
                this.taskSuccessful(player);
                player.closeInventory();
                return;
            }
            this.playerDigitCount.put(player, newDigitCount);
            for (i2 = 0; i2 < newDigitCount; ++i2) {
                ItemStack sequenceItemStack = ItemMaker.createStack(MATERIALS[this.playerPasswordMap.get(player).get(i2)], 1, "\u00a73Memorize the sequence and enter it below.", new String[0]);
                inv.setItem(1 + i2, sequenceItemStack);
            }
            for (i2 = newDigitCount; i2 < 7; ++i2) {
                inv.setItem(1 + i2, this.blackGlassStack());
            }
        } else if (currentDigitIndex == 0) {
            inv.setItem(1, this.greenGlassStack());
            for (i = 1; i < 7; ++i) {
                inv.setItem(1 + i, this.redGlassStack());
            }
        } else {
            inv.setItem(1 + currentDigitIndex, this.greenGlassStack());
        }
    }

    private ItemStack blackGlassStack() {
        ItemStack stack = new ItemStack(Material.BLACK_STAINED_GLASS, 1);
        ItemMeta im = stack.getItemMeta();
        im.displayName((Component)Component.text((String)"\u00a77This part of the code will be used later."));
        stack.setItemMeta(im);
        return stack;
    }

    private ItemStack redGlassStack() {
        ItemStack stack = new ItemStack(Material.RED_STAINED_GLASS, 1);
        ItemMeta im = stack.getItemMeta();
        im.displayName((Component)Component.text((String)"\u00a7cYou can't see this right now!"));
        stack.setItemMeta(im);
        return stack;
    }

    private ItemStack greenGlassStack() {
        ItemStack stack = new ItemStack(Material.GREEN_STAINED_GLASS, 1);
        ItemMeta im = stack.getItemMeta();
        im.displayName((Component)Component.text((String)"\u00a7aYou already solved this one."));
        stack.setItemMeta(im);
        return stack;
    }
}

