/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor.task.maintaskexecutors;

import io.github.greatericontop.greatimpostor.GreatImpostorMain;
import io.github.greatericontop.greatimpostor.task.BaseTask;
import io.github.greatericontop.greatimpostor.task.TaskType;
import io.github.greatericontop.greatimpostor.utils.ImpostorUtil;
import java.util.Random;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TaskStabilizeNavigation
extends BaseTask {
    public static final String INVENTORY_NAME = "\u00a7aAmong Us - Stabilize Navigation";
    private static final int MIDDLE = 22;
    private static final int[] dInv = new int[]{-1, 1, -9, 9};

    public TaskStabilizeNavigation(GreatImpostorMain plugin) {
        super(plugin);
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.STABILIZE_NAVIGATION;
    }

    @Override
    public void startTask(Player player) {
        int startingPos;
        Random random = new Random();
        Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)45, (Component)Component.text((String)INVENTORY_NAME));
        while ((startingPos = random.nextInt(45)) == 22 || startingPos == 23 || startingPos == 21 || startingPos == 31 || startingPos == 13) {
        }
        gui.setItem(startingPos, this.currentBlockItemStack());
        for (int d : dInv) {
            int slot = startingPos + d;
            if (slot < 0 || slot >= 45 || !ImpostorUtil.checkOrthoInvSlots(startingPos, slot)) continue;
            gui.setItem(slot, this.moveItemStack());
        }
        gui.setItem(22, this.targetBlockItemStack());
        player.openInventory(gui);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getView().getTitle().equals(INVENTORY_NAME)) {
            return;
        }
        event.setCancelled(true);
        if (!event.getClickedInventory().equals(event.getView().getTopInventory())) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        int clickedOn = event.getSlot();
        int currentLocation = event.getInventory().first(Material.WHITE_WOOL);
        if (!ImpostorUtil.checkOrthoInvSlots(currentLocation, clickedOn)) {
            this.playFailSound(player);
            return;
        }
        if (clickedOn == 22) {
            this.playSuccessSound(player);
            this.taskSuccessful(player);
            player.closeInventory();
            return;
        }
        Inventory gui = event.getInventory();
        gui.clear();
        gui.setItem(clickedOn, this.currentBlockItemStack());
        for (int d : dInv) {
            int slot = clickedOn + d;
            if (slot < 0 || slot >= 45 || !ImpostorUtil.checkOrthoInvSlots(clickedOn, slot)) continue;
            gui.setItem(slot, this.moveItemStack());
        }
        gui.setItem(22, this.targetBlockItemStack());
    }

    private ItemStack targetBlockItemStack() {
        ItemStack stack = new ItemStack(Material.TARGET, 1);
        ItemMeta im = stack.getItemMeta();
        im.addEnchant(Enchantment.LUCK, 1, true);
        im.displayName((Component)Component.text((String)"\u00a7eGet the target here."));
        stack.setItemMeta(im);
        return stack;
    }

    private ItemStack currentBlockItemStack() {
        ItemStack stack = new ItemStack(Material.WHITE_WOOL, 1);
        ItemMeta im = stack.getItemMeta();
        im.addEnchant(Enchantment.LUCK, 1, true);
        im.displayName((Component)Component.text((String)"\u00a7eThe ship is currently set here."));
        stack.setItemMeta(im);
        return stack;
    }

    private ItemStack moveItemStack() {
        ItemStack stack = new ItemStack(Material.WHITE_STAINED_GLASS_PANE, 1);
        ItemMeta im = stack.getItemMeta();
        im.displayName((Component)Component.text((String)"\u00a77Click"));
        stack.setItemMeta(im);
        return stack;
    }
}

