/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor.task.maintaskexecutors;

import io.github.greatericontop.greatimpostor.GreatImpostorMain;
import io.github.greatericontop.greatimpostor.task.BaseTask;
import io.github.greatericontop.greatimpostor.task.TaskType;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TaskRedirectPower
extends BaseTask {
    public static final String INVENTORY_NAME = "\u00a7aAmong Us - Redirect Power";
    private static final Material[] MATERIALS = new Material[]{Material.IRON_INGOT, Material.GOLD_INGOT, Material.EMERALD, Material.REDSTONE, Material.LAPIS_LAZULI, Material.DIAMOND};
    private static final String[] MATERIAL_NAMES = new String[]{"\u00a7f\u00a7lIRON", "\u00a76GOLD", "\u00a72EMERALD", "\u00a74REDSTONE", "\u00a79LAPIS", "\u00a7bDIAMOND"};
    private final Map<UUID, Integer> playerItemNumbers = new HashMap<UUID, Integer>();

    public TaskRedirectPower(GreatImpostorMain plugin) {
        super(plugin);
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.REDIRECT_ACCEPT_POWER;
    }

    @Override
    public void startTask(Player player) {
        Random random = new Random();
        Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)54, (Component)Component.text((String)INVENTORY_NAME));
        int targetItemNumber = random.nextInt(MATERIALS.length);
        this.playerItemNumbers.put(player.getUniqueId(), targetItemNumber);
        for (int i = 0; i < 54; ++i) {
            ItemStack stack = new ItemStack(MATERIALS[random.nextInt(MATERIALS.length)], 1);
            ItemMeta im = stack.getItemMeta();
            im.displayName((Component)Component.text((String)String.format("\u00a7eClick on all of the %s\u00a7e.", MATERIAL_NAMES[targetItemNumber])));
            stack.setItemMeta(im);
            gui.setItem(i, stack);
        }
        player.openInventory(gui);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Material targetMaterial;
        if (!event.getView().getTitle().equals(INVENTORY_NAME)) {
            return;
        }
        event.setCancelled(true);
        if (!event.getClickedInventory().equals(event.getView().getTopInventory())) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (event.getCurrentItem() == null) {
            return;
        }
        Material clickedMaterial = event.getCurrentItem().getType();
        if (clickedMaterial == (targetMaterial = MATERIALS[this.playerItemNumbers.get(player.getUniqueId())])) {
            this.playSuccessSound(player);
            event.getInventory().setItem(event.getSlot(), null);
            this.messWithInventory(event.getInventory(), new Random());
            if (this.containsNone(event.getInventory(), targetMaterial)) {
                this.taskSuccessful(player);
                player.closeInventory();
            }
        } else {
            this.playFailSound(player);
            player.sendMessage("\u00a7cYou clicked on the wrong item! You failed!");
            player.closeInventory();
        }
    }

    private boolean containsNone(Inventory inventory, Material material) {
        for (ItemStack stack : inventory.getContents()) {
            if (stack == null || stack.getType() != material) continue;
            return false;
        }
        return true;
    }

    private void messWithInventory(Inventory inventory, Random random) {
        for (int i = 0; i < 8; ++i) {
            int x = random.nextInt(54);
            int y = random.nextInt(54);
            ItemStack temp = inventory.getItem(x);
            inventory.setItem(x, inventory.getItem(y));
            inventory.setItem(y, temp);
        }
    }
}

