/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor.task.maintaskexecutors;

import io.github.greatericontop.greatimpostor.GreatImpostorMain;
import io.github.greatericontop.greatimpostor.task.BaseTask;
import io.github.greatericontop.greatimpostor.task.TaskType;
import io.github.greatericontop.greatimpostor.utils.ItemMaker;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class TaskPrimeShields
extends BaseTask {
    public static final String INVENTORY_NAME = "\u00a7aAmong Us - Prime Shields";
    private static final Material GOOD_MAT = Material.LIME_CONCRETE;
    private static final int TOPLEFT = 3;
    private static final int TOP = 4;
    private static final int TOPRIGHT = 5;
    private static final int LEFT = 12;
    private static final int MIDDLE = 13;
    private static final int RIGHT = 14;
    private static final int BOTTOMLEFT = 21;
    private static final int BOTTOM = 22;
    private static final int BOTTOMRIGHT = 23;
    private static final int[] ALL_POSITIONS = new int[]{3, 4, 5, 12, 13, 14, 21, 22, 23};
    private static final Map<Integer, List<Integer>> SURROUNDINGS = Map.of(3, List.of(Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(12)), 4, List.of(Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(13)), 5, List.of(Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(14)), 12, List.of(Integer.valueOf(3), Integer.valueOf(12), Integer.valueOf(13), Integer.valueOf(21)), 13, List.of(Integer.valueOf(4), Integer.valueOf(12), Integer.valueOf(13), Integer.valueOf(14), Integer.valueOf(22)), 14, List.of(Integer.valueOf(5), Integer.valueOf(13), Integer.valueOf(14), Integer.valueOf(23)), 21, List.of(Integer.valueOf(12), Integer.valueOf(21), Integer.valueOf(22)), 22, List.of(Integer.valueOf(13), Integer.valueOf(21), Integer.valueOf(22), Integer.valueOf(23)), 23, List.of(Integer.valueOf(14), Integer.valueOf(22), Integer.valueOf(23)));

    public TaskPrimeShields(GreatImpostorMain plugin) {
        super(plugin);
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.PRIME_SHIELDS;
    }

    @Override
    public void startTask(Player player) {
        Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)27, (Component)Component.text((String)INVENTORY_NAME));
        for (int slot : ALL_POSITIONS) {
            gui.setItem(slot, TaskPrimeShields.getNodeItem(Math.random() < 0.3));
        }
        player.openInventory(gui);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getView().getTitle().equals(INVENTORY_NAME)) {
            return;
        }
        event.setCancelled(true);
        if (!event.getClickedInventory().equals(event.getView().getTopInventory())) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        int clickedSlot = event.getSlot();
        List<Integer> neighbors = SURROUNDINGS.get(clickedSlot);
        if (neighbors == null) {
            return;
        }
        for (int slot : neighbors) {
            ItemStack item = event.getClickedInventory().getItem(slot);
            if (item != null && item.getType() == GOOD_MAT) {
                event.getClickedInventory().setItem(slot, TaskPrimeShields.getNodeItem(false));
                continue;
            }
            event.getClickedInventory().setItem(slot, TaskPrimeShields.getNodeItem(true));
        }
        boolean allGreen = true;
        for (int slot : ALL_POSITIONS) {
            ItemStack stack = event.getClickedInventory().getItem(slot);
            if (stack != null && stack.getType() == GOOD_MAT) continue;
            allGreen = false;
            break;
        }
        if (allGreen) {
            this.playSuccessSound(player);
            this.taskSuccessful(player);
            player.closeInventory();
        }
    }

    private static ItemStack getNodeItem(boolean isGood) {
        Material mat = isGood ? GOOD_MAT : Material.LIGHT_GRAY_CONCRETE;
        return ItemMaker.createStack(mat, 1, "\u00a7eClick", "\u00a73Turn all of them green!");
    }
}

