/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor.task.maintaskexecutors;

import io.github.greatericontop.greatimpostor.GreatImpostorMain;
import io.github.greatericontop.greatimpostor.task.BaseTask;
import io.github.greatericontop.greatimpostor.task.TaskType;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TaskFuelEngines
extends BaseTask {
    public static final String INVENTORY_NAME = "\u00a7aAmong Us - Fuel Engines";
    private static final int[] CANISTER_SLOTS = new int[]{11, 12, 13, 14, 15, 16, 25, 34, 43, 52, 51, 50, 49, 48, 47};
    private static final int[] CANISTER_EMPTY_ORDER = new int[]{20, 21, 29, 22, 23, 30, 24, 31, 38, 32, 39, 33, 40, 41, 42};
    private static final int BUTTON_SLOT = 0;

    public TaskFuelEngines(GreatImpostorMain plugin) {
        super(plugin);
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.FUEL_ENGINES;
    }

    @Override
    public void startTask(Player player) {
        Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)54, (Component)Component.text((String)INVENTORY_NAME));
        for (int i : CANISTER_SLOTS) {
            gui.setItem(i, new ItemStack(Material.STONE, 1));
        }
        for (int i : CANISTER_EMPTY_ORDER) {
            gui.setItem(i, new ItemStack(Material.BROWN_STAINED_GLASS_PANE, 1));
        }
        ItemStack stack = new ItemStack(Material.CHARCOAL, 1);
        ItemMeta im = stack.getItemMeta();
        im.addEnchant(Enchantment.LUCK, 1, true);
        im.displayName((Component)Component.text((String)"\u00a7eClick to deposit the fuel can into the engine!"));
        stack.setItemMeta(im);
        gui.setItem(0, stack);
        player.openInventory(gui);
    }

    @EventHandler
    public void onInventoryClick(final InventoryClickEvent event) {
        if (!event.getView().getTitle().equals(INVENTORY_NAME)) {
            return;
        }
        event.setCancelled(true);
        if (!event.getClickedInventory().equals(event.getView().getTopInventory())) {
            return;
        }
        final Player player = (Player)event.getWhoClicked();
        if (event.getSlot() != 0) {
            return;
        }
        if (event.getInventory().getItem(0) == null) {
            return;
        }
        event.getInventory().setItem(0, null);
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
        new BukkitRunnable(){
            int loopNum = 0;

            public void run() {
                if (event.getViewers().isEmpty()) {
                    TaskFuelEngines.this.playFailSound(player);
                    player.sendMessage("\u00a7cYou closed the inventory!");
                    this.cancel();
                    return;
                }
                if (this.loopNum == CANISTER_EMPTY_ORDER.length) {
                    TaskFuelEngines.this.playSuccessSound(player);
                    TaskFuelEngines.this.taskSuccessful(player);
                    player.closeInventory();
                    this.cancel();
                    return;
                }
                event.getInventory().setItem(CANISTER_EMPTY_ORDER[this.loopNum], null);
                ++this.loopNum;
            }
        }.runTaskTimer((Plugin)this.plugin, 6L, 6L);
    }
}

