/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor.task.maintaskexecutors;

import io.github.greatericontop.greatimpostor.GreatImpostorMain;
import io.github.greatericontop.greatimpostor.task.BaseTask;
import io.github.greatericontop.greatimpostor.task.TaskType;
import io.github.greatericontop.greatimpostor.utils.ItemMaker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TaskAnalyzeSample
extends BaseTask {
    public static final String INVENTORY_NAME = "\u00a7aAmong Us - Analyze Sample";
    private static final int START_BUTTON = 13;
    private static final int[] SAMPLES = new int[]{46, 48, 50, 52};
    private static final List<Integer> SAMPLES_L = List.of(Integer.valueOf(46), Integer.valueOf(48), Integer.valueOf(50), Integer.valueOf(52));
    private final Random random = new Random();
    private final Map<UUID, Status> playerStatusMap = new HashMap<UUID, Status>();
    private final Map<UUID, Integer> timeLeftCached = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> whichSample = new HashMap<UUID, Integer>();

    public TaskAnalyzeSample(GreatImpostorMain plugin) {
        super(plugin);
    }

    public void resetSelf() {
        this.playerStatusMap.clear();
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.ANALYZE_SAMPLE;
    }

    @Override
    public void startTask(Player player) {
        if (!this.playerStatusMap.containsKey(player.getUniqueId())) {
            this.playerStatusMap.put(player.getUniqueId(), Status.NOT_STARTED);
            this.whichSample.put(player.getUniqueId(), SAMPLES[this.random.nextInt(SAMPLES.length)]);
        }
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)54, (Component)Component.text((String)INVENTORY_NAME));
        this.updateInventory(player, inv, this.timeLeftCached.getOrDefault(player.getUniqueId(), -1));
        player.openInventory(inv);
    }

    @EventHandler
    public void onClick(final InventoryClickEvent event) {
        if (!event.getView().getTitle().equals(INVENTORY_NAME)) {
            return;
        }
        event.setCancelled(true);
        if (!event.getClickedInventory().equals(event.getView().getTopInventory())) {
            return;
        }
        final Player player = (Player)event.getWhoClicked();
        Status status = this.playerStatusMap.get(player.getUniqueId());
        switch (status) {
            case NOT_STARTED: {
                if (event.getSlot() != 13) break;
                this.playerStatusMap.put(player.getUniqueId(), Status.WAITING);
                new BukkitRunnable(){
                    int secondsLeft = 61;

                    public void run() {
                        --this.secondsLeft;
                        TaskAnalyzeSample.this.timeLeftCached.put(player.getUniqueId(), this.secondsLeft);
                        if (this.secondsLeft <= 0) {
                            TaskAnalyzeSample.this.playerStatusMap.put(player.getUniqueId(), Status.READY);
                            TaskAnalyzeSample.this.updateInventory(player, event.getInventory(), -1);
                            this.cancel();
                        } else if (player.getOpenInventory().getTitle().equals(TaskAnalyzeSample.INVENTORY_NAME)) {
                            TaskAnalyzeSample.this.updateInventory(player, player.getOpenInventory().getTopInventory(), this.secondsLeft);
                        }
                    }
                }.runTaskTimer((Plugin)this.plugin, 1L, 20L);
                break;
            }
            case READY: {
                if (!SAMPLES_L.contains(event.getSlot())) break;
                if (this.whichSample.get(player.getUniqueId()).intValue() == event.getSlot()) {
                    this.playSuccessSound(player);
                    this.taskSuccessful(player);
                    player.closeInventory();
                    break;
                }
                this.playFailSound(player);
                player.sendMessage((Component)Component.text((String)"\u00a7cThis sample does not contain the anomaly!"));
                player.closeInventory();
                this.playerStatusMap.remove(player.getUniqueId());
                break;
            }
        }
    }

    private void updateInventory(Player player, Inventory inv, int secondsLeft) {
        Status status = this.playerStatusMap.get(player.getUniqueId());
        switch (status) {
            case NOT_STARTED: {
                inv.setItem(13, ItemMaker.createStack(Material.BREWING_STAND, 1, "\u00a73Start Analysis", new String[0]));
                for (int slot : SAMPLES) {
                    ItemStack stack = new ItemStack(Material.POTION, 1);
                    PotionMeta im = (PotionMeta)stack.getItemMeta();
                    im.displayName((Component)Component.text((String)String.format("\u00a76Sample %d", (slot - 44) / 2)));
                    im.setColor(Color.fromRGB((int)0xAAAAAA));
                    stack.setItemMeta((ItemMeta)im);
                    inv.setItem(slot, stack);
                }
                break;
            }
            case WAITING: {
                inv.setItem(13, ItemMaker.createStack(Material.CLOCK, 1, String.format("\u00a7eAnalyzing... \u00a76%d \u00a7eseconds left", secondsLeft), "\u00a77Grab a coffee?"));
                for (int slot : SAMPLES) {
                    ItemStack stack = new ItemStack(Material.POTION, 1);
                    PotionMeta im = (PotionMeta)stack.getItemMeta();
                    im.displayName((Component)Component.text((String)String.format("\u00a76Sample %d", (slot - 44) / 2)));
                    im.setColor(Color.fromRGB((int)0xAAAAAA));
                    stack.setItemMeta((ItemMeta)im);
                    inv.setItem(slot, stack);
                }
                break;
            }
            case READY: {
                inv.setItem(13, ItemMaker.createStack(Material.LIME_CONCRETE, 1, "\u00a7aAnalysis complete! Click on the sample with the anomaly.", new String[0]));
                for (int slot : SAMPLES) {
                    ItemStack stack = new ItemStack(Material.POTION, 1);
                    PotionMeta im = (PotionMeta)stack.getItemMeta();
                    im.displayName((Component)Component.text((String)String.format("\u00a76Sample %d", (slot - 44) / 2)));
                    im.setColor(this.whichSample.get(player.getUniqueId()) == slot ? Color.fromRGB((int)0xAA0000) : Color.fromRGB((int)0xFFFFFF));
                    stack.setItemMeta((ItemMeta)im);
                    inv.setItem(slot, stack);
                }
                break;
            }
        }
    }

    private static enum Status {
        NOT_STARTED,
        WAITING,
        READY;

    }
}

