/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor.task.maintaskexecutors;

import io.github.greatericontop.greatimpostor.GreatImpostorMain;
import io.github.greatericontop.greatimpostor.task.BaseTask;
import io.github.greatericontop.greatimpostor.task.TaskType;
import io.github.greatericontop.greatimpostor.utils.ImpostorUtil;
import java.util.Random;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TaskAdjustSteering
extends BaseTask {
    public static final String INVENTORY_NAME = "\u00a7aAmong Us - Adjust Steering";
    private static final Material ROCK = Material.BEDROCK;
    private static final Material PREVIOUS_PATH = Material.WHITE_STAINED_GLASS_PANE;
    private static final Material CURRENT = Material.WHITE_WOOL;

    public TaskAdjustSteering(GreatImpostorMain plugin) {
        super(plugin);
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.ADJUST_STEERING;
    }

    @Override
    public void startTask(Player player) {
        ItemMeta im;
        ItemStack stack;
        int i;
        Random random = new Random();
        Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)54, (Component)Component.text((String)INVENTORY_NAME));
        for (i = 0; i < 54; ++i) {
            stack = new ItemStack(Material.GRAY_STAINED_GLASS_PANE, 1);
            im = stack.getItemMeta();
            im.displayName((Component)Component.text((String)"\u00a7eStarting from the left, make a path to the right side."));
            stack.setItemMeta(im);
            gui.setItem(i, stack);
        }
        for (i = 0; i < 20; ++i) {
            stack = new ItemStack(ROCK, 1);
            im = stack.getItemMeta();
            im.displayName((Component)Component.text((String)"\u00a7cDon't touch this."));
            stack.setItemMeta(im);
            gui.setItem(random.nextInt(54), stack);
        }
        player.openInventory(gui);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getView().getTitle().equals(INVENTORY_NAME)) {
            return;
        }
        event.setCancelled(true);
        if (!event.getClickedInventory().equals(event.getView().getTopInventory())) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Inventory inv = event.getInventory();
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null) {
            return;
        }
        if (clickedItem.getType() == PREVIOUS_PATH) {
            this.playFailSound(player);
            return;
        }
        if (clickedItem.getType() == ROCK) {
            this.playFailSound(player);
            player.closeInventory();
            player.sendMessage("\u00a7cYou crashed into the rock!");
            return;
        }
        int clickLocation = event.getSlot();
        Integer lastKnownLocation = this.findLastKnownLocation(inv);
        if (lastKnownLocation == null) {
            if (clickLocation % 9 != 0) {
                this.playFailSound(player);
                return;
            }
        } else if (!ImpostorUtil.checkOrthoInvSlots(clickLocation, lastKnownLocation)) {
            this.playFailSound(player);
            return;
        }
        if (lastKnownLocation != null) {
            inv.setItem(lastKnownLocation.intValue(), new ItemStack(PREVIOUS_PATH, 1));
        }
        ItemStack currentItemStack = new ItemStack(CURRENT, 1);
        ItemMeta im = currentItemStack.getItemMeta();
        im.displayName((Component)Component.text((String)"\u00a7eThis is your current position."));
        currentItemStack.setItemMeta(im);
        inv.setItem(clickLocation, currentItemStack);
        if (clickLocation % 9 == 8) {
            this.playSuccessSound(player);
            this.taskSuccessful(player);
            player.closeInventory();
        } else {
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.0f);
        }
    }

    private Integer findLastKnownLocation(Inventory inv) {
        for (int i = 0; i < 54; ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack == null || stack.getType() != CURRENT) continue;
            return i;
        }
        return null;
    }
}

