/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor.task;

import io.github.greatericontop.greatimpostor.task.Subtask;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TaskType {
    WIRING(true, 3, Subtask.WIRING_ELECTRICAL, Subtask.WIRING_STORAGE, Subtask.WIRING_ADMIN, Subtask.WIRING_NAVIGATION, Subtask.WIRING_CAFETERIA, Subtask.WIRING_SECURITY),
    REDIRECT_ACCEPT_POWER(true, 2, new Subtask[]{Subtask.REDIRECT_POWER, Subtask.ACCEPT_POWER_COMMUNICATIONS, Subtask.ACCEPT_POWER_LOWER_ENGINE, Subtask.ACCEPT_POWER_UPPER_ENGINE, Subtask.ACCEPT_POWER_NAVIGATION, Subtask.ACCEPT_POWER_OXYGEN, Subtask.ACCEPT_POWER_SECURITY, Subtask.ACCEPT_POWER_SHIELDS, Subtask.ACCEPT_POWER_WEAPONS}){

        @Override
        public Subtask[] getPossibleNextSubtasks(int numberSubtasksAlreadyCompleted) {
            if (numberSubtasksAlreadyCompleted == 0) {
                return new Subtask[]{Subtask.REDIRECT_POWER};
            }
            return new Subtask[]{Subtask.ACCEPT_POWER_COMMUNICATIONS, Subtask.ACCEPT_POWER_LOWER_ENGINE, Subtask.ACCEPT_POWER_UPPER_ENGINE, Subtask.ACCEPT_POWER_NAVIGATION, Subtask.ACCEPT_POWER_OXYGEN, Subtask.ACCEPT_POWER_SECURITY, Subtask.ACCEPT_POWER_SHIELDS, Subtask.ACCEPT_POWER_WEAPONS};
        }
    }
    ,
    DOWNLOAD_UPLOAD_DATA(true, 2, new Subtask[]{Subtask.DOWNLOAD_DATA_CAFETERIA, Subtask.DOWNLOAD_DATA_COMMUNICATIONS, Subtask.DOWNLOAD_DATA_ELECTRICAL, Subtask.DOWNLOAD_DATA_NAVIGATION, Subtask.DOWNLOAD_DATA_WEAPONS, Subtask.UPLOAD_DATA}){

        @Override
        public Subtask[] getPossibleNextSubtasks(int numberSubtasksAlreadyCompleted) {
            if (numberSubtasksAlreadyCompleted == 0) {
                return new Subtask[]{Subtask.DOWNLOAD_DATA_CAFETERIA, Subtask.DOWNLOAD_DATA_COMMUNICATIONS, Subtask.DOWNLOAD_DATA_ELECTRICAL, Subtask.DOWNLOAD_DATA_NAVIGATION, Subtask.DOWNLOAD_DATA_WEAPONS};
            }
            return new Subtask[]{Subtask.UPLOAD_DATA};
        }
    }
    ,
    FUEL_ENGINES(4, new Subtask[]{Subtask.FUEL_ENGINES_UPPER, Subtask.FUEL_ENGINES_LOWER}){

        @Override
        public Subtask[] getPossibleNextSubtasks(int numberSubtasksAlreadyCompleted) {
            if (numberSubtasksAlreadyCompleted == 0) {
                return new Subtask[]{Subtask.FETCH_FUEL};
            }
            if (numberSubtasksAlreadyCompleted == 1) {
                return new Subtask[]{Subtask.FUEL_ENGINES_LOWER};
            }
            if (numberSubtasksAlreadyCompleted == 2) {
                return new Subtask[]{Subtask.FETCH_FUEL};
            }
            return new Subtask[]{Subtask.FUEL_ENGINES_UPPER};
        }

        @Override
        public boolean doAlreadyCompletedCheck() {
            return false;
        }
    }
    ,
    SWIPE_CARD(1, Subtask.SWIPE_CARD),
    ADJUST_STEERING(1, Subtask.ADJUST_STEERING),
    CLEAN_OXYGEN_FILTER(1, Subtask.CLEAN_OXYGEN_FILTER),
    CLEAR_ASTEROIDS(1, Subtask.CLEAR_ASTEROIDS),
    EMPTY_TRASH(2, Subtask.EMPTY_TRASH_CAFETERIA, Subtask.EMPTY_TRASH_STORAGE),
    STABILIZE_NAVIGATION(1, Subtask.STABILIZE_NAVIGATION),
    START_REACTOR(1, Subtask.START_REACTOR),
    UNLOCK_MANIFOLDS(1, Subtask.UNLOCK_MANIFOLDS),
    SUBMIT_SCAN(1, Subtask.SUBMIT_SCAN),
    PRIME_SHIELDS(1, Subtask.PRIME_SHIELDS),
    ANALYZE_SAMPLE(1, Subtask.ANALYZE_SAMPLE);

    private final int requiredSubtaskCount;
    private final Subtask[] subtasks;
    private final boolean isFrequent;

    public int getRequiredSubtaskCount() {
        return this.requiredSubtaskCount;
    }

    public Subtask[] getSubtasks() {
        return this.subtasks;
    }

    public boolean isFrequent() {
        return this.isFrequent;
    }

    private TaskType(int requiredSubtaskCount, Subtask ... subtasks) {
        this.requiredSubtaskCount = requiredSubtaskCount;
        this.subtasks = subtasks;
        this.isFrequent = false;
    }

    private TaskType(boolean isFrequent, int requiredSubtaskCount, Subtask ... subtasks) {
        this.requiredSubtaskCount = requiredSubtaskCount;
        this.subtasks = subtasks;
        this.isFrequent = isFrequent;
    }

    public Subtask[] getPossibleNextSubtasks(int numberSubtasksAlreadyCompleted) {
        return this.subtasks;
    }

    public boolean doAlreadyCompletedCheck() {
        return true;
    }
}

