/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor.task;

import io.github.greatericontop.greatimpostor.GreatImpostorMain;
import io.github.greatericontop.greatimpostor.core.profiles.PlayerProfile;
import io.github.greatericontop.greatimpostor.task.BaseTask;
import io.github.greatericontop.greatimpostor.task.Subtask;
import io.github.greatericontop.greatimpostor.task.TaskUtil;
import io.github.greatericontop.greatimpostor.task.sabotage.BaseSabotageTask;
import io.github.greatericontop.greatimpostor.task.sabotage.SabotageSubtask;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class SignListener
implements Listener {
    public static final NamespacedKey TASK_SIGN_KEY = new NamespacedKey("greatimpostor", "task_sign");
    private final GreatImpostorMain plugin;

    public SignListener(GreatImpostorMain plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onSignClick(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        if (event.getClickedBlock().getType() != Material.OAK_SIGN && event.getClickedBlock().getType() != Material.OAK_WALL_SIGN) {
            return;
        }
        Sign signBlock = (Sign)event.getClickedBlock().getState();
        PersistentDataContainer pdc = signBlock.getPersistentDataContainer();
        if (!pdc.has(TASK_SIGN_KEY, PersistentDataType.STRING)) {
            return;
        }
        String subtaskName = (String)pdc.get(TASK_SIGN_KEY, PersistentDataType.STRING);
        Player player = event.getPlayer();
        PlayerProfile profile = this.plugin.playerProfiles.get(player.getUniqueId());
        if (profile == null) {
            player.sendMessage("\u00a7cCouldn't get your profile!");
            return;
        }
        if (subtaskName.equalsIgnoreCase("@emergency")) {
            this.plugin.meetingManager.callEmergencyMeeting(player);
            return;
        }
        if (subtaskName.startsWith("@sabotage=")) {
            if (!profile.isAlive()) {
                player.sendMessage("\u00a7cYou can't fix sabotages while dead!");
                return;
            }
            this.executeSabotageTask(player, subtaskName.replaceFirst("@sabotage=", ""));
            return;
        }
        if (subtaskName.startsWith("@securitycameras")) {
            this.plugin.securityCameraManager.enterCameras(profile, player);
            return;
        }
        this.executeMainTask(profile, player, subtaskName);
    }

    private void executeSabotageTask(Player player, String sabotageName) {
        SabotageSubtask sabotage = SabotageSubtask.valueOf(sabotageName);
        if (this.plugin.sabotageManager.getActiveSabotage() != sabotage.getFullSabotage()) {
            player.sendMessage("\u00a7cThis sabotage does not need to be fixed!");
            return;
        }
        BaseSabotageTask baseSabotageTask = TaskUtil.getSabotageTaskClass(this.plugin, sabotage.getFullSabotage());
        baseSabotageTask.startTask(player, sabotage);
    }

    private void executeMainTask(PlayerProfile profile, Player player, String subtaskName) {
        Subtask subtask = Subtask.valueOf(subtaskName);
        if (!profile.tasks.contains((Object)subtask)) {
            player.sendMessage("\u00a7cYou don't have this task!");
            return;
        }
        if (profile.isFullyCompleted(subtask.getFullTask())) {
            player.sendMessage("\u00a7cYou already fully completed this task!");
            return;
        }
        BaseTask baseTask = TaskUtil.getTaskClass(this.plugin, subtask);
        baseTask.startTask(player);
    }
}

