/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor.pathfinding;

import io.github.greatericontop.greatimpostor.GreatImpostorMain;
import io.github.greatericontop.greatimpostor.core.profiles.PlayerProfile;
import io.github.greatericontop.greatimpostor.pathfinding.XYZ;
import io.github.greatericontop.greatimpostor.task.Subtask;
import io.github.greatericontop.greatimpostor.task.sabotage.SabotageSubtask;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.util.Vector;

public class PathfindingHelperListener
implements Listener {
    private static final int STEPS_NORMAL = 10;
    private static final int STEPS_SABOTAGE = 17;
    private static final int PARTICLE_STEP = 10;
    private static final int PARTICLE_STEP_DIAGONAL = 14;
    private final GreatImpostorMain plugin;

    public PathfindingHelperListener(GreatImpostorMain plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onLeftClick(PlayerInteractEvent event) {
        if (event.getAction() != Action.LEFT_CLICK_AIR && event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        PlayerProfile profile = this.plugin.playerProfiles.get(player.getUniqueId());
        if (profile == null) {
            return;
        }
        Material heldMat = player.getInventory().getItemInMainHand().getType();
        int heldIndex = player.getInventory().getHeldItemSlot();
        if (heldMat == Material.RED_STAINED_GLASS || heldMat == Material.YELLOW_STAINED_GLASS) {
            Subtask currentSubtask = profile.tasks.get(heldIndex);
            if (!this.plugin.mapGraph.signToGraph.containsKey((Object)currentSubtask)) {
                player.sendMessage("\u00a7cSorry, I couldn't pathfind that task for you!");
                return;
            }
            XYZ target = this.plugin.mapGraph.signToGraph.get((Object)currentSubtask);
            this.showPath(player, target, true, 10, Particle.WAX_OFF);
        }
    }

    public void showSabotagePath(Player player, SabotageSubtask subtask) {
        if (!this.plugin.mapGraph.sabotageSignToGraph.containsKey((Object)subtask)) {
            return;
        }
        XYZ target = this.plugin.mapGraph.sabotageSignToGraph.get((Object)subtask);
        this.showPath(player, target, false, 17, Particle.WAX_ON);
    }

    private void showPath(Player player, XYZ target, boolean showHint, int rayLength, Particle particle) {
        XYZ cur = new XYZ(player.getLocation().getBlockX(), this.plugin.mapGraph.yLevel, player.getLocation().getBlockZ());
        for (int i = 0; i < rayLength; ++i) {
            XYZ next = this.plugin.mapGraph.shortestPathsCache.get(target).get(cur);
            if (next == null) {
                if (i != 0 || !showHint) break;
                player.sendMessage("\u00a7cYour current position is obstructed, please get back on the floor and try again!");
                break;
            }
            int step = cur.x() != next.x() && cur.z() != next.z() ? 14 : 10;
            Location loc = new Location(player.getWorld(), (double)cur.x() + 0.5, (double)cur.y() + 0.5, (double)cur.z() + 0.5);
            Vector vec = new Vector(next.x() - cur.x(), 0, next.z() - cur.z()).multiply(1.0 / (double)step);
            for (int j = 0; j < step; ++j) {
                loc.add(vec);
                player.spawnParticle(particle, loc, 1, 0.0, 0.0, 0.0, 0.0);
            }
            cur = next;
        }
    }
}

