/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor.pathfinding;

import io.github.greatericontop.greatimpostor.GreatImpostorMain;
import io.github.greatericontop.greatimpostor.pathfinding.XYZ;
import io.github.greatericontop.greatimpostor.task.SignListener;
import io.github.greatericontop.greatimpostor.task.Subtask;
import io.github.greatericontop.greatimpostor.task.sabotage.SabotageSubtask;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class MapGraph {
    private static final int MAX_NODES = 30000;
    private static final int MAX_Y = 3;
    public int yLevel;
    public final List<String> messages = new ArrayList<String>();
    private final Map<XYZ, List<XYZ>> adj = new HashMap<XYZ, List<XYZ>>();
    public final Map<XYZ, Map<XYZ, XYZ>> shortestPathsCache = new HashMap<XYZ, Map<XYZ, XYZ>>();
    public final Map<Subtask, XYZ> signToGraph = new HashMap<Subtask, XYZ>();
    public final Map<SabotageSubtask, XYZ> sabotageSignToGraph = new HashMap<SabotageSubtask, XYZ>();
    private final GreatImpostorMain plugin;

    public MapGraph(GreatImpostorMain plugin) {
        this.plugin = plugin;
    }

    public void generate(World world, XYZ root) {
        if (!this.adj.isEmpty()) {
            throw new IllegalStateException("Graph has already been generated");
        }
        if (!root.isEmpty(world)) {
            this.messages.add("Root vertex of the map graph is not air, cannot generate graph");
            this.plugin.getLogger().warning("Root vertex of the map graph is not air, cannot generate graph");
            return;
        }
        this.yLevel = root.y();
        HashSet<XYZ> visited = new HashSet<XYZ>();
        ArrayDeque<XYZ> vertexQueue = new ArrayDeque<XYZ>();
        vertexQueue.add(root);
        while (!vertexQueue.isEmpty() && this.adj.size() < 30000) {
            XYZ vertex = (XYZ)vertexQueue.poll();
            if (visited.contains(vertex)) continue;
            visited.add(vertex);
            if (!vertex.isEmpty(world)) {
                throw new IllegalStateException("Vertex in the vertex queue is not air, this should never happen!");
            }
            if (this.adj.containsKey(vertex)) {
                throw new IllegalStateException("There should be no adj entry for a vertex in the vertex queue!");
            }
            this.adj.put(vertex, new ArrayList(8));
            XYZ plusX = vertex.add(1, 0);
            XYZ minusX = vertex.add(-1, 0);
            XYZ plusZ = vertex.add(0, 1);
            XYZ minusZ = vertex.add(0, -1);
            XYZ plusXPlusZ = vertex.add(1, 1);
            XYZ plusXMinusZ = vertex.add(1, -1);
            XYZ minusXPlusZ = vertex.add(-1, 1);
            XYZ minusXMinusZ = vertex.add(-1, -1);
            if (plusX.isEmpty(world)) {
                this.adj.get(vertex).add(plusX);
                vertexQueue.add(plusX);
            }
            if (minusX.isEmpty(world)) {
                this.adj.get(vertex).add(minusX);
                vertexQueue.add(minusX);
            }
            if (plusZ.isEmpty(world)) {
                this.adj.get(vertex).add(plusZ);
                vertexQueue.add(plusZ);
            }
            if (minusZ.isEmpty(world)) {
                this.adj.get(vertex).add(minusZ);
                vertexQueue.add(minusZ);
            }
            if (plusXPlusZ.isEmpty(world) && plusX.isEmpty(world) && plusZ.isEmpty(world)) {
                this.adj.get(vertex).add(plusXPlusZ);
                vertexQueue.add(plusXPlusZ);
            }
            if (plusXMinusZ.isEmpty(world) && plusX.isEmpty(world) && minusZ.isEmpty(world)) {
                this.adj.get(vertex).add(plusXMinusZ);
                vertexQueue.add(plusXMinusZ);
            }
            if (minusXPlusZ.isEmpty(world) && minusX.isEmpty(world) && plusZ.isEmpty(world)) {
                this.adj.get(vertex).add(minusXPlusZ);
                vertexQueue.add(minusXPlusZ);
            }
            if (!minusXMinusZ.isEmpty(world) || !minusX.isEmpty(world) || !minusZ.isEmpty(world)) continue;
            this.adj.get(vertex).add(minusXMinusZ);
            vertexQueue.add(minusXMinusZ);
        }
        this.messages.add("Generated map graph with %d vertices!".formatted(this.adj.size()));
        this.plugin.getLogger().info("Generated map graph with %d vertices!".formatted(this.adj.size()));
    }

    private void generateSingleTargetShortestPath(XYZ root) {
        if (this.adj.isEmpty()) {
            throw new IllegalStateException("Graph has not been generated yet");
        }
        HashMap<XYZ, XYZ> parentTable = new HashMap<XYZ, XYZ>();
        ArrayDeque<XYZ> vertexQueue = new ArrayDeque<XYZ>();
        parentTable.put(root, null);
        vertexQueue.add(root);
        while (!vertexQueue.isEmpty()) {
            XYZ vertex = (XYZ)vertexQueue.poll();
            for (XYZ neighbor : this.adj.get(vertex)) {
                if (parentTable.containsKey(neighbor)) continue;
                parentTable.put(neighbor, vertex);
                vertexQueue.add(neighbor);
            }
        }
        this.shortestPathsCache.put(root, parentTable);
    }

    /*
     * WARNING - void declaration
     */
    public void findSignsInGraph(World world) {
        Location vertexLoc;
        if (this.adj.isEmpty()) {
            throw new IllegalStateException("Graph has not been generated yet");
        }
        for (XYZ vertex : this.adj.keySet()) {
            vertexLoc = vertex.toLocation(world);
            for (int y = -3; y <= 3; ++y) {
                Subtask subtask;
                Sign signBlock;
                PersistentDataContainer pdc;
                Block block = world.getBlockAt(vertexLoc.clone().add(0.0, (double)y, 0.0));
                if (block.getType() != Material.OAK_SIGN && block.getType() != Material.OAK_WALL_SIGN || !(pdc = (signBlock = (Sign)block.getState()).getPersistentDataContainer()).has(SignListener.TASK_SIGN_KEY, PersistentDataType.STRING)) continue;
                String subtaskName = (String)pdc.get(SignListener.TASK_SIGN_KEY, PersistentDataType.STRING);
                if (subtaskName.startsWith("@")) {
                    void subtask2;
                    if (!subtaskName.startsWith("@sabotage=")) continue;
                    String sabotageSubtaskName = subtaskName.replaceFirst("@sabotage=", "");
                    try {
                        SabotageSubtask subtask22 = SabotageSubtask.valueOf(sabotageSubtaskName);
                    }
                    catch (IllegalArgumentException e) {
                        this.messages.add("Found sign with invalid sabotage subtask name '%s'".formatted(subtaskName));
                        this.plugin.getLogger().warning("Found sign with invalid sabotage subtask name '%s'".formatted(subtaskName));
                        continue;
                    }
                    if (this.sabotageSignToGraph.containsKey(subtask2)) {
                        this.messages.add("Found multiple signs for subtask %s, ignoring all but the first one".formatted(subtask2.name()));
                        this.plugin.getLogger().warning("Found multiple signs for subtask %s, ignoring all but the first one".formatted(subtask2.name()));
                        continue;
                    }
                    this.sabotageSignToGraph.put((SabotageSubtask)subtask2, vertex);
                    this.generateSingleTargetShortestPath(vertex);
                    continue;
                }
                try {
                    subtask = Subtask.valueOf(subtaskName);
                }
                catch (IllegalArgumentException e) {
                    this.messages.add("Found sign with invalid subtask name '%s'".formatted(subtaskName));
                    this.plugin.getLogger().warning("Found sign with invalid subtask name '%s'".formatted(subtaskName));
                    continue;
                }
                if (this.signToGraph.containsKey((Object)subtask)) {
                    this.messages.add("Found multiple signs for subtask %s, ignoring all but the first one".formatted(subtask.name()));
                    this.plugin.getLogger().warning("Found multiple signs for subtask %s, ignoring all but the first one".formatted(subtask.name()));
                    continue;
                }
                this.signToGraph.put(subtask, vertex);
                this.generateSingleTargetShortestPath(vertex);
            }
        }
        for (XYZ vertex : this.adj.keySet()) {
            vertexLoc = vertex.toLocation(world);
            for (int x = -1; x <= 1; ++x) {
                for (int i = -1; i <= 1; ++i) {
                    for (int y = -3; y <= 3; ++y) {
                        Subtask subtask;
                        Sign signBlock;
                        PersistentDataContainer pdc;
                        Block b = world.getBlockAt(vertexLoc.clone().add((double)x, (double)y, (double)i));
                        if (b.getType() != Material.OAK_SIGN && b.getType() != Material.OAK_WALL_SIGN || !(pdc = (signBlock = (Sign)b.getState()).getPersistentDataContainer()).has(SignListener.TASK_SIGN_KEY, PersistentDataType.STRING)) continue;
                        String subtaskName = (String)pdc.get(SignListener.TASK_SIGN_KEY, PersistentDataType.STRING);
                        if (subtaskName.startsWith("@")) {
                            void subtask3;
                            if (!subtaskName.startsWith("@sabotage=")) continue;
                            String sabotageSubtaskName = subtaskName.replaceFirst("@sabotage=", "");
                            try {
                                SabotageSubtask subtask32 = SabotageSubtask.valueOf(sabotageSubtaskName);
                            }
                            catch (IllegalArgumentException e) {
                                this.messages.add("Found sign with invalid sabotage subtask name '%s'".formatted(subtaskName));
                                this.plugin.getLogger().warning("Found sign with invalid sabotage subtask name '%s'".formatted(subtaskName));
                                continue;
                            }
                            if (this.sabotageSignToGraph.containsKey(subtask3)) continue;
                            this.sabotageSignToGraph.put((SabotageSubtask)subtask3, vertex);
                            this.generateSingleTargetShortestPath(vertex);
                            continue;
                        }
                        try {
                            subtask = Subtask.valueOf(subtaskName);
                        }
                        catch (IllegalArgumentException e) {
                            this.messages.add("Found sign with invalid subtask name '%s'".formatted(subtaskName));
                            this.plugin.getLogger().warning("Found sign with invalid subtask name '%s'".formatted(subtaskName));
                            continue;
                        }
                        if (this.signToGraph.containsKey((Object)subtask)) continue;
                        this.signToGraph.put(subtask, vertex);
                        this.generateSingleTargetShortestPath(vertex);
                    }
                }
            }
        }
        ArrayList<String> missing = new ArrayList<String>();
        for (Subtask subtask : Subtask.values()) {
            if (this.signToGraph.containsKey((Object)subtask)) continue;
            missing.add(subtask.name());
        }
        for (Enum enum_ : SabotageSubtask.values()) {
            if (this.sabotageSignToGraph.containsKey(enum_)) continue;
            missing.add(enum_.name());
        }
        if (!missing.isEmpty()) {
            this.messages.add("No signs found for subtasks: %s".formatted(String.join((CharSequence)", ", missing)));
            this.plugin.getLogger().warning("No signs found for subtasks: %s".formatted(String.join((CharSequence)", ", missing)));
        } else {
            this.messages.add("Found signs for all subtasks!");
            this.plugin.getLogger().info("Found signs for all subtasks!");
        }
    }
}

