/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor.meeting;

import io.github.greatericontop.greatimpostor.GreatImpostorMain;
import io.github.greatericontop.greatimpostor.core.profiles.PlayerProfile;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class VotingCommand
implements CommandExecutor,
TabCompleter {
    private final GreatImpostorMain plugin;

    public VotingCommand(GreatImpostorMain plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            return false;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cPlayers only!");
            return true;
        }
        Player player = (Player)sender;
        if (!this.plugin.meetingManager.isVotingPhaseActive()) {
            sender.sendMessage("\u00a7cYou can only vote during meetings!");
            return true;
        }
        PlayerProfile playerProfile = this.plugin.playerProfiles.get(player.getUniqueId());
        if (playerProfile == null) {
            sender.sendMessage("\u00a7cCouldn't get your profile!");
            return true;
        }
        if (!playerProfile.isAlive()) {
            sender.sendMessage("\u00a7cYou're dead! You can't vote!");
            return true;
        }
        if (args[0].equalsIgnoreCase("skip")) {
            this.plugin.meetingManager.votes.remove(playerProfile);
            this.plugin.meetingManager.skips.add(playerProfile);
            player.sendMessage("\u00a7dYou voted to skip!");
        } else {
            Player targetPlayer = this.plugin.getServer().getPlayer(args[0]);
            if (targetPlayer == null) {
                sender.sendMessage("\u00a7cCouldn't find that player!");
                return true;
            }
            PlayerProfile targetPlayerProfile = this.plugin.playerProfiles.get(targetPlayer.getUniqueId());
            if (targetPlayerProfile == null) {
                sender.sendMessage("\u00a7cCouldn't get that player's profile!");
                return true;
            }
            if (!targetPlayerProfile.isAlive()) {
                sender.sendMessage("\u00a7cThat player is dead! You can't vote for them!");
                return true;
            }
            this.plugin.meetingManager.skips.remove(playerProfile);
            this.plugin.meetingManager.votes.put(playerProfile, targetPlayerProfile);
            player.sendMessage(String.format("\u00a7dYou voted to eject \u00a7e%s\u00a7d!", targetPlayer.getName()));
        }
        int alivePlayerCount = 0;
        for (PlayerProfile profile : this.plugin.playerProfiles.values()) {
            if (!profile.isAlive()) continue;
            ++alivePlayerCount;
        }
        Bukkit.broadcast((Component)Component.text((String)String.format("\u00a7b%s \u00a73voted (\u00a7e%d\u00a73/\u00a7e%d\u00a73)", player.getName(), this.plugin.meetingManager.votes.size() + this.plugin.meetingManager.skips.size(), alivePlayerCount)));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1) {
            ArrayList<String> alivePlayers = new ArrayList<String>();
            for (PlayerProfile profile : this.plugin.playerProfiles.values()) {
                if (!profile.isAlive()) continue;
                alivePlayers.add(profile.getPlayer().getName());
            }
            alivePlayers.add("skip");
            return alivePlayers;
        }
        return List.of();
    }
}

