/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor.meeting;

import io.github.greatericontop.greatimpostor.GreatImpostorMain;
import io.github.greatericontop.greatimpostor.core.profiles.ImpostorProfile;
import io.github.greatericontop.greatimpostor.core.profiles.PlayerProfile;
import io.github.greatericontop.greatimpostor.utils.CooldownResetReason;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MeetingManager {
    private int startTime = -1;
    private boolean meetingActive = false;
    private boolean postMeetingActive = false;
    private boolean doVoteCheck = true;
    public final Map<PlayerProfile, PlayerProfile> votes = new HashMap<PlayerProfile, PlayerProfile>();
    public final Set<PlayerProfile> skips = new HashSet<PlayerProfile>();
    private GreatImpostorMain plugin;

    public MeetingManager(GreatImpostorMain plugin) {
        this.plugin = plugin;
    }

    public boolean isMeetingActive() {
        return this.meetingActive;
    }

    public boolean isVotingPhaseActive() {
        return this.meetingActive && !this.postMeetingActive;
    }

    public void callEmergencyMeeting(Player callingPlayer) {
        if (this.isMeetingActive()) {
            callingPlayer.sendMessage("\u00a7cThere is already a meeting in progress!");
            return;
        }
        PlayerProfile profile = this.plugin.playerProfiles.get(callingPlayer.getUniqueId());
        if (profile == null) {
            callingPlayer.sendMessage("\u00a7cCouldn't get your profile!");
            return;
        }
        if (!profile.isAlive()) {
            callingPlayer.sendMessage("\u00a7cYou can't call meetings while dead!");
            return;
        }
        if (this.plugin.sabotageManager.isDisruptiveSabotageActive()) {
            callingPlayer.sendMessage("\u00a7cSabotage! You can't call a meeting right now!");
            return;
        }
        if (profile.getMeetingsCalled() >= this.plugin.getConfig().getInt("max-meetings-per-player")) {
            callingPlayer.sendMessage("\u00a7cYou have already called the maximum number of meetings!");
            return;
        }
        profile.incrementMeetingsCalled();
        callingPlayer.sendMessage(String.format("\u00a77%d/%d available meetings called", profile.getMeetingsCalled(), this.plugin.getConfig().getInt("max-meetings-per-player")));
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.showTitle(Title.title((Component)Component.text((String)"\u00a7cEmergency Meeting"), (Component)Component.text((String)("\u00a76" + callingPlayer.getName() + " called a meeting!")), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(1500L), (Duration)Duration.ofMillis(5000L), (Duration)Duration.ofMillis(1500L))));
        }
        this.startNewMeeting(true);
    }

    public void startNewMeeting(boolean isEmergency) {
        this.startTime = this.plugin.getClock();
        this.meetingActive = true;
        this.postMeetingActive = false;
        this.doVoteCheck = true;
        this.votes.clear();
        this.skips.clear();
        Bukkit.broadcast((Component)Component.text((String)"\u00a79--------------------------------------------------"));
        Bukkit.broadcast((Component)Component.text((String)""));
        Bukkit.broadcast((Component)Component.text((String)"\u00a74GreatImpostor"));
        Bukkit.broadcast((Component)Component.text((String)"\u00a76----- \u00a7aA meeting was called! \u00a76-----"));
        Bukkit.broadcast((Component)Component.text((String)""));
        Bukkit.broadcast((Component)Component.text((String)"\u00a73Who is the Impostor?"));
        Bukkit.broadcast((Component)Component.text((String)"\u00a73Use \u00a7b/vote \u00a73to vote."));
        Bukkit.broadcast((Component)Component.text((String)"\u00a73You can vote for a player, e.g. \u00a7b/vote Notch"));
        Bukkit.broadcast((Component)Component.text((String)"\u00a73Or skip the vote, e.g. \u00a7b/vote skip"));
        Bukkit.broadcast((Component)Component.text((String)""));
        this.playMeetingSound();
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.setGameMode(GameMode.SPECTATOR);
        }
        int number = this.plugin.gameManager.removeAllBodiesAndFakePlayers();
        if (number > 0) {
            if (isEmergency) {
                Bukkit.broadcast((Component)Component.text((String)String.format("\u00a7e%d \u00a76player(s) died between the last meeting and right now!", number)));
                Bukkit.broadcast((Component)Component.text((String)""));
            } else {
                Bukkit.broadcast((Component)Component.text((String)String.format("\u00a76In addition to the reported body, \u00a7e%d \u00a76player(s) died (\u00a7e%d \u00a76died in total)", number, number + 1)));
                Bukkit.broadcast((Component)Component.text((String)""));
            }
        }
        ArrayList<String> alivePlayers = new ArrayList<String>();
        ArrayList<String> deadPlayers = new ArrayList<String>();
        for (PlayerProfile profile : this.plugin.playerProfiles.values()) {
            if (profile.isAlive()) {
                alivePlayers.add(profile.renderNameDisplay("\u00a7x\u00a72\u00a72\u00a7c\u00a7c\u00a72\u00a72"));
            } else {
                deadPlayers.add(profile.renderNameDisplay("\u00a7x\u00a7c\u00a7c\u00a72\u00a72\u00a72\u00a72"));
            }
            if (profile instanceof ImpostorProfile) {
                ImpostorProfile impostorProfile = (ImpostorProfile)profile;
                if (impostorProfile.isInVent) {
                    impostorProfile.isInVent = false;
                }
            }
            if (!profile.isInCameras) continue;
            this.plugin.securityCameraManager.exitCameras(profile, profile.getPlayer());
        }
        Bukkit.broadcastMessage((String)String.format("\u00a7x\u00a72\u00a72\u00a7c\u00a7c\u00a72\u00a72Alive \u00a73Players: %s", String.join((CharSequence)", ", alivePlayers)));
        Bukkit.broadcastMessage((String)String.format("\u00a7x\u00a7c\u00a7c\u00a72\u00a72\u00a72\u00a72Dead \u00a73Players: %s", String.join((CharSequence)", ", deadPlayers)));
        Bukkit.broadcast((Component)Component.text((String)""));
        Bukkit.broadcast((Component)Component.text((String)"\u00a79--------------------------------------------------"));
    }

    public void endMeeting() {
        PlayerProfile toEject = this.doHighestVoted();
        if (toEject != null) {
            toEject.die();
        }
        Bukkit.broadcast((Component)Component.text((String)""));
        if (toEject == null) {
            Bukkit.broadcast((Component)Component.text((String)"\u00a7bNobody was ejected!"));
        } else {
            Bukkit.broadcast((Component)Component.text((String)String.format("\u00a7e%s \u00a7bwas ejected!", toEject.getPlayer().getName())));
            String impMessage = toEject.isImpostor() ? String.format("\u00a7e%s \u00a7bwas The Impostor.", toEject.getPlayer().getName()) : String.format("\u00a7e%s \u00a7bwas not The Impostor.", toEject.getPlayer().getName());
            Bukkit.broadcast((Component)Component.text((String)impMessage));
        }
        Bukkit.broadcast((Component)Component.text((String)""));
        int playersLeft = 0;
        int impostorsLeft = 0;
        for (PlayerProfile profile : this.plugin.playerProfiles.values()) {
            if (!profile.isAlive()) continue;
            ++playersLeft;
            if (!profile.isImpostor()) continue;
            ++impostorsLeft;
        }
        Bukkit.broadcast((Component)Component.text((String)String.format("\u00a7bThere are \u00a76%d \u00a7bimpostors left and \u00a76%d \u00a7bplayers left.", impostorsLeft, playersLeft)));
        Bukkit.broadcast((Component)Component.text((String)""));
        Bukkit.broadcast((Component)Component.text((String)"\u00a79--------------------------------------------------"));
        this.postMeetingActive = true;
    }

    public void setMeetingActionBar(Player player) {
        if (this.postMeetingActive) {
            player.sendActionBar((Component)Component.text((String)"\u00a76Continuing soon!"));
            return;
        }
        int secondsLeft = (this.plugin.getConfig().getInt("meeting-time-ticks") + this.startTime - this.plugin.getClock() + 19) / 20;
        String timeLeft = String.format("%d:%02d", secondsLeft / 60, secondsLeft % 60);
        player.sendActionBar((Component)Component.text((String)String.format("\u00a76Meeting - %s", timeLeft)));
    }

    private void playMeetingSound() {
        new BukkitRunnable(){
            int i = 0;

            public void run() {
                if (this.i >= 35) {
                    this.cancel();
                    return;
                }
                for (Player player : Bukkit.getOnlinePlayers()) {
                    player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 1.0f);
                }
                ++this.i;
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 2L);
    }

    public void registerMeetingRunnable() {
        new BukkitRunnable(){

            public void run() {
                if (!MeetingManager.this.isMeetingActive()) {
                    return;
                }
                int MEETING_TIME_TICKS = MeetingManager.this.plugin.getConfig().getInt("meeting-time-ticks");
                int ticksLeft = MEETING_TIME_TICKS + MeetingManager.this.startTime - MeetingManager.this.plugin.getClock();
                if (ticksLeft == 0) {
                    MeetingManager.this.endMeeting();
                }
                if (MeetingManager.this.doVoteCheck && MeetingManager.this.hasEveryoneVoted()) {
                    if (ticksLeft > 100) {
                        MeetingManager.this.startTime = MeetingManager.this.plugin.getClock() - MEETING_TIME_TICKS + 100;
                        Bukkit.broadcast((Component)Component.text((String)"\u00a7aEveryone has voted! The meeting will end in 5 seconds."));
                    } else {
                        Bukkit.broadcast((Component)Component.text((String)"\u00a7aEveryone has voted! The meeting will end soon."));
                    }
                    MeetingManager.this.doVoteCheck = false;
                }
                if (ticksLeft == -100) {
                    for (PlayerProfile profile : MeetingManager.this.plugin.playerProfiles.values()) {
                        if (profile.isImpostor()) {
                            ImpostorProfile impostorProfile = (ImpostorProfile)profile;
                            impostorProfile.resetKillCooldown(CooldownResetReason.AFTER_MEETING);
                        }
                        MeetingManager.this.plugin.gameManager.resetAllSabotageCooldowns(CooldownResetReason.AFTER_MEETING);
                        profile.getPlayer().setGameMode(GameMode.ADVENTURE);
                        profile.getPlayer().teleport(MeetingManager.this.plugin.getStartingLocation());
                    }
                    MeetingManager.this.meetingActive = false;
                    MeetingManager.this.postMeetingActive = false;
                }
                for (Player player : Bukkit.getOnlinePlayers()) {
                    player.teleport(MeetingManager.this.plugin.getStartingLocation());
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }

    public PlayerProfile doHighestVoted() {
        HashMap<PlayerProfile, Integer> voteCount = new HashMap<PlayerProfile, Integer>();
        for (PlayerProfile targetProfile : this.votes.values()) {
            voteCount.put(targetProfile, voteCount.getOrDefault(targetProfile, 0) + 1);
        }
        int maxVotes = this.skips.size();
        boolean isTied = false;
        PlayerProfile highestVoted = null;
        for (Map.Entry entry : voteCount.entrySet()) {
            if ((Integer)entry.getValue() > maxVotes) {
                maxVotes = (Integer)entry.getValue();
                highestVoted = (PlayerProfile)entry.getKey();
                isTied = false;
                continue;
            }
            if ((Integer)entry.getValue() != maxVotes) continue;
            isTied = true;
        }
        this.doMessages(voteCount, this.skips.size());
        if (isTied) {
            return null;
        }
        return highestVoted;
    }

    private void doMessages(Map<PlayerProfile, Integer> voteCount, int skipCount) {
        Bukkit.broadcast((Component)Component.text((String)"\u00a79--------------------------------------------------"));
        Bukkit.broadcast((Component)Component.text((String)""));
        Bukkit.broadcast((Component)Component.text((String)String.format("\u00a7aSkip\u00a77: \u00a7b%d", skipCount)));
        Bukkit.broadcast((Component)Component.text((String)""));
        TreeMap sortedVotes = new TreeMap(Comparator.reverseOrder());
        for (Map.Entry<PlayerProfile, Integer> entry : voteCount.entrySet()) {
            sortedVotes.putIfAbsent(entry.getValue(), new HashSet());
            ((Set)sortedVotes.get(entry.getValue())).add(entry.getKey());
        }
        for (Map.Entry<PlayerProfile, Integer> entry : sortedVotes.entrySet()) {
            for (PlayerProfile profile : (Set)((Object)entry.getValue())) {
                Bukkit.broadcast((Component)Component.text((String)String.format("\u00a7e%s\u00a77: \u00a7b%d", profile.getPlayer().getName(), entry.getKey())));
            }
        }
        Bukkit.broadcast((Component)Component.text((String)""));
        Bukkit.broadcast((Component)Component.text((String)"\u00a79--------------------------------------------------"));
    }

    private boolean hasEveryoneVoted() {
        int alivePlayerCount = 0;
        for (PlayerProfile profile : this.plugin.playerProfiles.values()) {
            if (!profile.isAlive()) continue;
            ++alivePlayerCount;
        }
        return this.votes.size() + this.skips.size() == alivePlayerCount;
    }

    public void killMeeting() {
        this.meetingActive = false;
        this.postMeetingActive = false;
    }
}

