/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor.core.profiles;

import io.github.greatericontop.greatimpostor.GreatImpostorMain;
import io.github.greatericontop.greatimpostor.task.Subtask;
import io.github.greatericontop.greatimpostor.task.TaskType;
import io.github.greatericontop.greatimpostor.task.TaskUtil;
import io.github.greatericontop.greatimpostor.utils.ItemMaker;
import io.github.greatericontop.greatimpostor.utils.PlayerColor;
import io.github.greatericontop.greatimpostor.utils.Shuffler;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public abstract class PlayerProfile {
    public static final int TASKS_PER = 4;
    protected final Random random;
    public final List<Subtask> tasks = new ArrayList<Subtask>();
    protected int[] subtasksCompletedPerTask = null;
    protected final Set<Subtask> tasksAlreadyCompleted = new HashSet<Subtask>();
    protected boolean alive;
    private final PlayerColor color;
    private int meetingsCalled;
    public boolean isInCameras;
    public int currentCameraNumber = -1;
    protected GreatImpostorMain plugin;
    protected final Player player;

    public Player getPlayer() {
        return this.player;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public PlayerColor getColor() {
        return this.color;
    }

    public int getMeetingsCalled() {
        return this.meetingsCalled;
    }

    public void incrementMeetingsCalled() {
        ++this.meetingsCalled;
    }

    public PlayerProfile(GreatImpostorMain plugin, Player player, PlayerColor color) {
        this.plugin = plugin;
        this.random = new Random();
        this.player = player;
        this.alive = true;
        this.color = color;
        this.meetingsCalled = 0;
        this.isInCameras = false;
    }

    public String renderNameDisplay(String nameColor) {
        return String.format("%s%s\u00a73(%s\u00a73)", nameColor, this.player.getName(), this.color.getDisplayName());
    }

    public static int[] getTaskStatus(Collection<PlayerProfile> profiles) {
        int completed = 0;
        int total = 0;
        for (PlayerProfile p : profiles) {
            if (p.isImpostor()) continue;
            for (int i = 0; i < p.tasks.size(); ++i) {
                if (p.isFullyCompleted(i)) {
                    ++completed;
                }
                ++total;
            }
        }
        return new int[]{completed, total};
    }

    public void setInitialTasks() {
        this.tasksAlreadyCompleted.clear();
        TaskType[] initialTasks = (TaskType[])TaskUtil.INITIAL_TASKS.clone();
        do {
            this.tasks.clear();
            Shuffler.shuffle((Object[])initialTasks, this.random);
            for (int i = 0; i < 4; ++i) {
                Subtask[] possible = initialTasks[i].getPossibleNextSubtasks(0);
                this.tasks.add(possible[this.random.nextInt(possible.length)]);
            }
        } while (this.getFrequentTaskCount() == 0 && this.random.nextDouble() < 0.85);
        this.subtasksCompletedPerTask = new int[]{0, 0, 0, 0};
    }

    private int getFrequentTaskCount() {
        int count = 0;
        for (Subtask subtask : this.tasks) {
            if (!subtask.getFullTask().isFrequent()) continue;
            ++count;
        }
        return count;
    }

    public boolean isFullyCompleted(TaskType taskType) {
        int taskIndex = -1;
        for (int i = 0; i < this.tasks.size(); ++i) {
            if (this.tasks.get(i).getFullTask() != taskType) continue;
            taskIndex = i;
            break;
        }
        if (taskIndex == -1) {
            return false;
        }
        return this.isFullyCompleted(taskIndex);
    }

    public boolean isFullyCompleted(int i) {
        return this.subtasksCompletedPerTask[i] >= this.tasks.get(i).getFullTask().getRequiredSubtaskCount();
    }

    public void processSubtaskCompleted(TaskType taskType) {
        for (int i = 0; i < this.tasks.size(); ++i) {
            if (this.tasks.get(i).getFullTask() != taskType) continue;
            this.processSubtaskCompleted(i, true);
            return;
        }
        throw new IllegalArgumentException("The given subtask couldn't be found in the list for this profile");
    }

    public void processSubtaskCompleted(int i, boolean shouldUpdateInventory) {
        int n = i;
        this.subtasksCompletedPerTask[n] = this.subtasksCompletedPerTask[n] + 1;
        this.tasksAlreadyCompleted.add(this.tasks.get(i));
        TaskType fullTask = this.tasks.get(i).getFullTask();
        if (this.subtasksCompletedPerTask[i] < fullTask.getRequiredSubtaskCount()) {
            Subtask nextSubtask;
            Subtask[] possibleNextSubtasks = fullTask.getPossibleNextSubtasks(this.subtasksCompletedPerTask[i]);
            do {
                nextSubtask = possibleNextSubtasks[this.random.nextInt(possibleNextSubtasks.length)];
            } while (fullTask.doAlreadyCompletedCheck() && this.tasksAlreadyCompleted.contains((Object)nextSubtask));
            this.tasks.set(i, nextSubtask);
        }
        if (shouldUpdateInventory) {
            this.setInventory();
        }
    }

    protected void dieGeneric() {
        this.alive = false;
        for (Player p : this.plugin.getServer().getOnlinePlayers()) {
            p.hidePlayer((Plugin)this.plugin, this.player);
        }
        this.player.showTitle(Title.title((Component)Component.text((String)"\u00a7cYou Died!"), (Component)Component.text((String)"\u00a7cYou Died!"), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(1000L), (Duration)Duration.ofMillis(8000L), (Duration)Duration.ofMillis(1000L))));
        this.player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 60, 4));
        this.player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 60, 4));
    }

    protected Inventory setInventoryCommon() {
        PlayerInventory inv = this.getPlayer().getInventory();
        inv.clear();
        inv.setItem(EquipmentSlot.HEAD, ItemMaker.createLeatherArmor(Material.LEATHER_HELMET, this.color.getColorCode(), this.color.getDisplayName()));
        inv.setItem(EquipmentSlot.CHEST, ItemMaker.createLeatherArmor(Material.LEATHER_CHESTPLATE, this.color.getColorCode(), this.color.getDisplayName()));
        inv.setItem(EquipmentSlot.LEGS, ItemMaker.createLeatherArmor(Material.LEATHER_LEGGINGS, this.color.getColorCode(), this.color.getDisplayName()));
        inv.setItem(EquipmentSlot.FEET, ItemMaker.createLeatherArmor(Material.LEATHER_BOOTS, this.color.getColorCode(), this.color.getDisplayName()));
        return inv;
    }

    public abstract void die();

    public abstract boolean isImpostor();

    public abstract void setActionBar();

    public abstract void setInventory();
}

