/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor.core.profiles;

import io.github.greatericontop.greatimpostor.GreatImpostorMain;
import io.github.greatericontop.greatimpostor.core.profiles.PlayerProfile;
import io.github.greatericontop.greatimpostor.task.Subtask;
import io.github.greatericontop.greatimpostor.task.sabotage.Sabotage;
import io.github.greatericontop.greatimpostor.utils.CooldownResetReason;
import io.github.greatericontop.greatimpostor.utils.ImpostorUtil;
import io.github.greatericontop.greatimpostor.utils.PlayerColor;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ImpostorProfile
extends PlayerProfile {
    public boolean isInVent = false;
    public int ventSystem = -1;
    public int ventNumber = -1;
    private int killCooldownTicks = Integer.MAX_VALUE;
    private int sabotageCooldownTicks = Integer.MAX_VALUE;
    public Sabotage selectedSabotage = Sabotage.REACTOR;

    public ImpostorProfile(GreatImpostorMain plugin, Player player, PlayerColor color) {
        super(plugin, player, color);
    }

    @Override
    public void die() {
        new BukkitRunnable(){

            public void run() {
                ImpostorProfile.this.player.sendMessage("\u00a76------------------------------");
                ImpostorProfile.this.player.sendMessage("\u00a7bOops! Looks like you \u00a7cdied\u00a7b!");
                ImpostorProfile.this.player.sendMessage("\u00a77You may not report bodies, call meetings, vote, or fix sabotages.");
                ImpostorProfile.this.player.sendMessage("\u00a77You can't kill, but you can still sabotage.");
                ImpostorProfile.this.player.sendMessage("\u00a76------------------------------");
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
        this.dieGeneric();
    }

    @Override
    public boolean isImpostor() {
        return true;
    }

    public boolean getCanKill() {
        return this.killCooldownTicks <= 0 && !this.plugin.meetingManager.isMeetingActive() && !this.isInVent;
    }

    public void resetKillCooldown(CooldownResetReason reason) {
        switch (reason) {
            case GAME_START: {
                this.killCooldownTicks = this.plugin.getConfig().getInt("impostor-cooldowns.kill-game-start");
                break;
            }
            case AFTER_USE: {
                this.killCooldownTicks = this.plugin.getConfig().getInt("impostor-cooldowns.kill-after-use");
                break;
            }
            case AFTER_MEETING: {
                this.killCooldownTicks = this.plugin.getConfig().getInt("impostor-cooldowns.kill-after-meeting");
            }
        }
    }

    public boolean getCanSabotage() {
        return this.sabotageCooldownTicks <= 0 && !this.plugin.meetingManager.isMeetingActive() && !this.isInVent;
    }

    public void resetSabotageCooldownSelfOnly(CooldownResetReason reason) {
        switch (reason) {
            case GAME_START: {
                this.sabotageCooldownTicks = this.plugin.getConfig().getInt("impostor-cooldowns.sabotage-game-start");
                break;
            }
            case AFTER_USE: {
                this.sabotageCooldownTicks = this.plugin.getConfig().getInt("impostor-cooldowns.sabotage-after-use");
                break;
            }
            case AFTER_MEETING: {
                this.sabotageCooldownTicks = this.plugin.getConfig().getInt("impostor-cooldowns.sabotage-after-meeting");
            }
        }
    }

    public void applyVentEntrancePenalty() {
        if (this.killCooldownTicks > 0) {
            this.killCooldownTicks = Math.min(this.killCooldownTicks + 60, this.plugin.getConfig().getInt("impostor-cooldowns.kill-after-use"));
        }
        if (this.sabotageCooldownTicks > 0) {
            this.sabotageCooldownTicks = Math.min(this.sabotageCooldownTicks + 60, this.plugin.getConfig().getInt("impostor-cooldowns.sabotage-after-use"));
        }
    }

    public void tickCooldowns() {
        if (!this.isInVent) {
            --this.killCooldownTicks;
            --this.sabotageCooldownTicks;
        }
    }

    @Override
    public void setActionBar() {
        String sabotage;
        String kill;
        if (this.isInVent) {
            String vent = "\u00a7aYou're in a vent!  \u00a77|  \u00a7eJUMP \u00a7bto cycle  \u00a77|  \u00a7eSNEAK \u00a7bto exit";
            this.player.sendActionBar((Component)Component.text((String)vent));
            return;
        }
        if (this.isInCameras) {
            this.player.sendActionBar((Component)Component.text((String)"\u00a7aSecurity Cameras  \u00a77|  \u00a7eJUMP \u00a7bto cycle  \u00a77|  \u00a7eSNEAK \u00a7bto exit"));
            return;
        }
        int[] taskStatus = ImpostorProfile.getTaskStatus(this.plugin.playerProfiles.values());
        Material holding = this.player.getInventory().getItemInMainHand().getType();
        String tasks = holding == Material.RED_STAINED_GLASS || holding == Material.YELLOW_STAINED_GLASS ? "\u00a76[LEFT CLICK for task location]" : String.format("\u00a76[Tasks \u00a7e%d/%d\u00a76]", taskStatus[0], taskStatus[1]);
        if (!this.isAlive()) {
            kill = "\u00a7c[Kill \u00a77Dead\u00a7c]";
        } else if (this.getCanKill()) {
            kill = "\u00a7c[Kill \u00a7aAVAILABLE\u00a7c]";
        } else {
            double seconds = 0.05 * (double)this.killCooldownTicks;
            kill = String.format("\u00a7c[Kill \u00a73%.1fs\u00a7c]", seconds);
        }
        if (this.plugin.sabotageManager.isSabotageActive()) {
            sabotage = String.format("\u00a7d[%s \u00a7eACTIVE\u00a7d]", this.plugin.sabotageManager.getActiveSabotage().getDisplayName());
        } else if (this.getCanSabotage()) {
            sabotage = String.format("\u00a7d[%s \u00a7aREADY\u00a7d]", this.selectedSabotage.getDisplayName());
        } else {
            double seconds = 0.05 * (double)this.sabotageCooldownTicks;
            sabotage = String.format("\u00a7d[%s \u00a73%.1fs\u00a7d]", this.selectedSabotage.getDisplayName(), seconds);
        }
        this.player.sendActionBar((Component)Component.text((String)String.format("%s   %s   %s", kill, tasks, sabotage)));
    }

    @Override
    public void setInventory() {
        Inventory inv = super.setInventoryCommon();
        if (this.plugin.sabotageManager.getActiveSabotage() == Sabotage.COMMUNICATIONS) {
            for (int i = 0; i < 4; ++i) {
                inv.setItem(i, ImpostorUtil.commsSabotageTaskDisplayItemStack());
            }
        } else {
            inv.setItem(0, ((Subtask)((Object)this.tasks.get(0))).getDisplayItemStack(this.subtasksCompletedPerTask[0], "\u00a77Fake A - "));
            inv.setItem(1, ((Subtask)((Object)this.tasks.get(1))).getDisplayItemStack(this.subtasksCompletedPerTask[1], "\u00a77Fake B - "));
            inv.setItem(2, ((Subtask)((Object)this.tasks.get(2))).getDisplayItemStack(this.subtasksCompletedPerTask[2], "\u00a77Fake C - "));
            inv.setItem(3, ((Subtask)((Object)this.tasks.get(3))).getDisplayItemStack(this.subtasksCompletedPerTask[3], "\u00a77Fake D - "));
        }
        ItemStack kill = new ItemStack(Material.NETHERITE_SWORD, 1);
        ItemMeta im = kill.getItemMeta();
        im.addEnchant(Enchantment.DAMAGE_ALL, 1, true);
        im.addAttributeModifier(Attribute.GENERIC_ATTACK_SPEED, new AttributeModifier(UUID.randomUUID(), "attack speed increase", 20.0, AttributeModifier.Operation.ADD_NUMBER));
        im.addAttributeModifier(Attribute.GENERIC_ATTACK_DAMAGE, new AttributeModifier(UUID.randomUUID(), "attack damage put back to normal value", 7.0, AttributeModifier.Operation.ADD_NUMBER));
        im.displayName((Component)Component.text((String)"\u00a74KILL"));
        kill.setItemMeta(im);
        inv.setItem(4, kill);
        ItemStack sabotageSelect = new ItemStack(Material.TNT, 1);
        im = sabotageSelect.getItemMeta();
        im.displayName((Component)Component.text((String)"\u00a7cSelect Sabotage"));
        im.lore(List.of(Component.text((String)"\u00a7bHotkey \u00a77to this item \u00a77(press \u00a766\u00a77 with default controls)"), Component.text((String)"\u00a77to change your selected sabotage."), Component.text((String)"\u00a77Your currently selected sabotage is displayed above your hotbar.")));
        sabotageSelect.setItemMeta(im);
        inv.setItem(5, sabotageSelect);
        ItemStack sabotageActivate = new ItemStack(Material.REDSTONE_TORCH, 1);
        im = sabotageActivate.getItemMeta();
        im.displayName((Component)Component.text((String)"\u00a7cActivate Sabotage"));
        im.lore(List.of(Component.text((String)"\u00a7bHotkey \u00a77to this item \u00a77(press \u00a767\u00a77 with default controls)"), Component.text((String)"\u00a77to activate your selected sabotage."), Component.text((String)"\u00a77Your currently selected sabotage is displayed above your hotbar.")));
        sabotageActivate.setItemMeta(im);
        inv.setItem(6, sabotageActivate);
        inv.setItem(8, ImpostorUtil.reportItemStack());
    }
}

