/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor.core.impostor;

import io.github.greatericontop.greatimpostor.GreatImpostorMain;
import io.github.greatericontop.greatimpostor.core.profiles.ImpostorProfile;
import io.github.greatericontop.greatimpostor.core.profiles.PlayerProfile;
import io.github.greatericontop.greatimpostor.utils.PartialCoordinates;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class VentManager
implements Listener {
    private final Map<UUID, Boolean> movementCooldown = new HashMap<UUID, Boolean>();
    private final GreatImpostorMain plugin;

    public VentManager(GreatImpostorMain plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onShift(PlayerToggleSneakEvent event) {
        if (!event.isSneaking()) {
            return;
        }
        Player player = event.getPlayer();
        PlayerProfile profileGeneric = this.plugin.playerProfiles.get(player.getUniqueId());
        if (profileGeneric == null) {
            return;
        }
        if (!profileGeneric.isImpostor()) {
            PartialCoordinates coordinates = PartialCoordinates.ofLocation(player.getLocation());
            if (this.plugin.gameManager.findVentSystem(coordinates) != null) {
                player.sendMessage("\u00a77To prevent abuse, you can't shift on vents.");
                event.setCancelled(true);
            }
            return;
        }
        ImpostorProfile profile = (ImpostorProfile)profileGeneric;
        if (profile.isInVent) {
            this.exitVent(player, profile);
        } else {
            this.enterVent(player, profile);
        }
    }

    @EventHandler
    public void onSpace(PlayerMoveEvent event) {
        if (event.getTo().getY() - 0.05 <= event.getFrom().getY()) {
            return;
        }
        if (this.movementCooldown.getOrDefault(event.getPlayer().getUniqueId(), false).booleanValue()) {
            return;
        }
        final Player player = event.getPlayer();
        PlayerProfile profileGeneric = this.plugin.playerProfiles.get(player.getUniqueId());
        if (profileGeneric == null) {
            return;
        }
        if (!profileGeneric.isImpostor()) {
            return;
        }
        ImpostorProfile profile = (ImpostorProfile)profileGeneric;
        if (profile.isInVent) {
            this.cycleVent(player, profile);
            this.movementCooldown.put(player.getUniqueId(), true);
            new BukkitRunnable(){

                public void run() {
                    VentManager.this.movementCooldown.put(player.getUniqueId(), false);
                }
            }.runTaskLater((Plugin)this.plugin, 10L);
        }
    }

    private void exitVent(Player player, ImpostorProfile profile) {
        profile.isInVent = false;
        PartialCoordinates coordinates = this.plugin.gameManager.getVent(profile.ventSystem, profile.ventNumber);
        player.teleport(coordinates.teleportLocation(player.getWorld()));
        player.setGameMode(GameMode.ADVENTURE);
    }

    private void enterVent(Player player, ImpostorProfile profile) {
        Location playerLocation = player.getLocation();
        PartialCoordinates coordinates = PartialCoordinates.ofLocation(playerLocation);
        int[] ventData = this.plugin.gameManager.findVentSystem(coordinates);
        if (ventData == null) {
            return;
        }
        int ventSystem = ventData[0];
        int ventNumber = ventData[1];
        if (!profile.isAlive()) {
            player.sendMessage("\u00a7cYou're dead! You can't use vents!");
            return;
        }
        profile.isInVent = true;
        profile.ventSystem = ventSystem;
        profile.ventNumber = ventNumber;
        profile.applyVentEntrancePenalty();
        player.setGameMode(GameMode.SPECTATOR);
    }

    private void cycleVent(Player player, ImpostorProfile profile) {
        int nextVentNumber;
        int ventSystem = profile.ventSystem;
        int ventNumber = profile.ventNumber;
        profile.ventNumber = nextVentNumber = (ventNumber + 1) % this.plugin.gameManager.getVentCount(ventSystem);
        PartialCoordinates coordinates = this.plugin.gameManager.getVent(ventSystem, nextVentNumber);
        player.teleport(coordinates.teleportLocation(player.getWorld()));
    }

    public void setBackVentedImpostor(ImpostorProfile profile) {
        Player player;
        if (!profile.isInVent) {
            return;
        }
        PartialCoordinates coordinates = this.plugin.gameManager.getVent(profile.ventSystem, profile.ventNumber);
        if (coordinates.isClose(PartialCoordinates.ofLocation((player = profile.getPlayer()).getLocation()))) {
            return;
        }
        player.teleport(coordinates.teleportLocation(player.getWorld()));
    }
}

