/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor.core.impostor;

import io.github.greatericontop.greatimpostor.GreatImpostorMain;
import io.github.greatericontop.greatimpostor.core.profiles.ImpostorProfile;
import io.github.greatericontop.greatimpostor.core.profiles.PlayerProfile;
import io.github.greatericontop.greatimpostor.utils.CooldownResetReason;
import io.github.greatericontop.greatimpostor.utils.ImpostorUtil;
import java.util.UUID;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.EulerAngle;

public class ImpostorKillListener
implements Listener {
    private final GreatImpostorMain plugin;

    public ImpostorKillListener(GreatImpostorMain plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onHit(EntityDamageByEntityEvent event) {
        Player victimPlayer;
        Entity entity = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        boolean isFakePlayerKill = false;
        if (event.getEntity() instanceof Player) {
            victimPlayer = (Player)event.getEntity();
        } else {
            ArmorStand entity2;
            Entity entity3 = event.getEntity();
            if (!(entity3 instanceof ArmorStand) || !(entity2 = (ArmorStand)entity3).getPersistentDataContainer().has(ImpostorUtil.FAKE_PLAYER_KEY, PersistentDataType.STRING)) {
                return;
            }
            victimPlayer = Bukkit.getPlayer((UUID)UUID.fromString((String)entity2.getPersistentDataContainer().get(ImpostorUtil.FAKE_PLAYER_KEY, PersistentDataType.STRING)));
            if (victimPlayer == null) {
                return;
            }
            isFakePlayerKill = true;
        }
        PlayerProfile profile = this.plugin.playerProfiles.get(player.getUniqueId());
        if (profile == null) {
            return;
        }
        event.setCancelled(true);
        if (!profile.isImpostor()) {
            player.sendMessage("\u00a7cYou can't attack others!");
            return;
        }
        ImpostorProfile impostorProfile = (ImpostorProfile)profile;
        if (!impostorProfile.isAlive()) {
            player.sendMessage("\u00a7cYou can't kill while dead!");
            return;
        }
        if (event.getDamage() < 2.0) {
            player.sendMessage("\u00a7cYou must use your sword!");
            return;
        }
        if (!impostorProfile.getCanKill()) {
            player.sendMessage("\u00a7cYou can't kill right now!");
            return;
        }
        PlayerProfile victimProfile = this.plugin.playerProfiles.get(victimPlayer.getUniqueId());
        if (victimProfile == null) {
            player.sendMessage("\u00a7cThis player isn't in this game!");
            return;
        }
        if (victimProfile.isImpostor()) {
            player.sendMessage("\u00a7cDon't kill your fellow impostors!");
            return;
        }
        impostorProfile.resetKillCooldown(CooldownResetReason.AFTER_USE);
        if (isFakePlayerKill) {
            this.plugin.securityCameraManager.exitCameras(victimProfile, victimPlayer);
        }
        victimProfile.die();
        this.generateDeadBody(event.getEntity().getLocation(), victimPlayer);
    }

    public void generateDeadBody(Location loc, @Nullable Player deadPlayer) {
        ArmorStand armorStand = (ArmorStand)loc.getWorld().spawn(loc.add(0.0, -1.15, 0.0), ArmorStand.class);
        armorStand.setInvulnerable(true);
        armorStand.setGravity(false);
        armorStand.setArms(false);
        armorStand.setHeadPose(new EulerAngle(1.5707963267948966, 0.0, Math.PI));
        armorStand.setBodyPose(new EulerAngle(1.5707963267948966, 0.0, Math.PI));
        ItemStack head = new ItemStack(Material.PLAYER_HEAD, 1);
        if (deadPlayer != null) {
            SkullMeta headMeta = (SkullMeta)head.getItemMeta();
            headMeta.setOwningPlayer((OfflinePlayer)deadPlayer);
            head.setItemMeta((ItemMeta)headMeta);
        }
        armorStand.getEquipment().setHelmet(head);
        ItemStack chestplate = new ItemStack(Material.LEATHER_CHESTPLATE, 1);
        LeatherArmorMeta armorMeta = (LeatherArmorMeta)chestplate.getItemMeta();
        armorMeta.setColor(Color.fromRGB((int)0x990000));
        chestplate.setItemMeta((ItemMeta)armorMeta);
        armorStand.getEquipment().setChestplate(chestplate);
        armorStand.getPersistentDataContainer().set(ImpostorUtil.DEAD_BODY_KEY, PersistentDataType.INTEGER, (Object)1);
    }
}

