/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor.core.events;

import io.github.greatericontop.greatimpostor.GreatImpostorMain;
import io.github.greatericontop.greatimpostor.core.profiles.PlayerProfile;
import io.github.greatericontop.greatimpostor.task.sabotage.Sabotage;
import io.github.greatericontop.greatimpostor.utils.ImpostorUtil;
import io.github.greatericontop.greatimpostor.utils.ItemMaker;
import io.github.greatericontop.greatimpostor.utils.PartialCoordinates;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SecurityCameraManager
implements Listener {
    private final List<PartialCoordinates> cameraSystem;
    private final Map<UUID, Location> originalLocations = new HashMap<UUID, Location>();
    private final Map<UUID, Boolean> movementCooldown = new HashMap<UUID, Boolean>();
    private final GreatImpostorMain plugin;

    public SecurityCameraManager(GreatImpostorMain plugin) {
        this.plugin = plugin;
        this.cameraSystem = new ArrayList<PartialCoordinates>();
        this.loadCamerasFromConfig();
    }

    private void loadCamerasFromConfig() {
        this.plugin.getConfig().getList("cameras").forEach(rawCoords -> {
            List coords = (List)rawCoords;
            this.cameraSystem.add(PartialCoordinates.fromConfigEntry(coords));
        });
    }

    public void enterCameras(PlayerProfile profile, final Player player) {
        if (!profile.isAlive()) {
            player.sendMessage("\u00a7cYou can't view security cameras while dead!");
            return;
        }
        if (profile.isInCameras) {
            player.sendMessage("\u00a7cYou're already viewing the security cameras.");
            return;
        }
        if (this.plugin.sabotageManager.getActiveSabotage() == Sabotage.COMMUNICATIONS) {
            player.sendMessage("\u00a7cCommunications are offline!");
            return;
        }
        profile.isInCameras = true;
        profile.currentCameraNumber = -1;
        this.originalLocations.put(player.getUniqueId(), player.getLocation());
        player.setGameMode(GameMode.SPECTATOR);
        this.spawnFakePlayer(profile, player);
        this.cycleCamera(profile, player);
        this.movementCooldown.put(player.getUniqueId(), true);
        new BukkitRunnable(){

            public void run() {
                SecurityCameraManager.this.movementCooldown.put(player.getUniqueId(), false);
            }
        }.runTaskLater((Plugin)this.plugin, 20L);
    }

    @EventHandler
    public void onSpace(PlayerMoveEvent event) {
        if (event.getTo().getY() - 0.05 <= event.getFrom().getY()) {
            return;
        }
        if (this.movementCooldown.getOrDefault(event.getPlayer().getUniqueId(), false).booleanValue()) {
            return;
        }
        final Player player = event.getPlayer();
        PlayerProfile profile = this.plugin.playerProfiles.get(player.getUniqueId());
        if (profile == null) {
            return;
        }
        if (profile.isInCameras) {
            this.cycleCamera(profile, player);
            this.movementCooldown.put(player.getUniqueId(), true);
            new BukkitRunnable(){

                public void run() {
                    SecurityCameraManager.this.movementCooldown.put(player.getUniqueId(), false);
                }
            }.runTaskLater((Plugin)this.plugin, 10L);
        }
    }

    @EventHandler
    public void onShift(PlayerToggleSneakEvent event) {
        if (!event.isSneaking()) {
            return;
        }
        Player player = event.getPlayer();
        PlayerProfile profile = this.plugin.playerProfiles.get(player.getUniqueId());
        if (profile == null) {
            return;
        }
        if (profile.isInCameras) {
            this.exitCameras(profile, player);
        }
    }

    private void cycleCamera(PlayerProfile profile, Player player) {
        int nextNum;
        profile.currentCameraNumber = nextNum = (profile.currentCameraNumber + 1) % this.cameraSystem.size();
        PartialCoordinates cameraCoords = this.cameraSystem.get(nextNum);
        player.teleport(cameraCoords.teleportLocation(player.getWorld()));
    }

    public void exitCameras(PlayerProfile profile, Player player) {
        profile.isInCameras = false;
        player.setGameMode(GameMode.ADVENTURE);
        Location originalLoc = this.originalLocations.get(player.getUniqueId());
        player.teleport(originalLoc);
        for (Entity e2 : player.getWorld().getNearbyEntities(originalLoc, 0.1, 0.1, 0.1, e -> e instanceof ArmorStand)) {
            String uuidString;
            if (!e2.getPersistentDataContainer().has(ImpostorUtil.FAKE_PLAYER_KEY, PersistentDataType.STRING) || !(uuidString = (String)e2.getPersistentDataContainer().get(ImpostorUtil.FAKE_PLAYER_KEY, PersistentDataType.STRING)).equals(player.getUniqueId().toString())) continue;
            e2.remove();
            break;
        }
    }

    public void setBackSecurityCameraPlayer(PlayerProfile profile) {
        Player player;
        if (!profile.isInCameras) {
            return;
        }
        PartialCoordinates coordinates = this.cameraSystem.get(profile.currentCameraNumber);
        if (coordinates.isClose(PartialCoordinates.ofLocation((player = profile.getPlayer()).getLocation()))) {
            return;
        }
        player.teleport(coordinates.teleportLocation(player.getWorld()));
    }

    private void spawnFakePlayer(PlayerProfile profile, Player player) {
        ArmorStand armorStand = (ArmorStand)player.getWorld().spawn(player.getLocation(), ArmorStand.class);
        armorStand.setGravity(false);
        ItemStack head = new ItemStack(Material.PLAYER_HEAD, 1);
        SkullMeta headMeta = (SkullMeta)head.getItemMeta();
        headMeta.setOwningPlayer((OfflinePlayer)player);
        head.setItemMeta((ItemMeta)headMeta);
        armorStand.getEquipment().setHelmet(head);
        armorStand.getEquipment().setChestplate(ItemMaker.createLeatherArmor(Material.LEATHER_CHESTPLATE, profile.getColor().getColorCode(), ""));
        armorStand.getEquipment().setLeggings(ItemMaker.createLeatherArmor(Material.LEATHER_LEGGINGS, profile.getColor().getColorCode(), ""));
        armorStand.getEquipment().setBoots(ItemMaker.createLeatherArmor(Material.LEATHER_BOOTS, profile.getColor().getColorCode(), ""));
        armorStand.getPersistentDataContainer().set(ImpostorUtil.FAKE_PLAYER_KEY, PersistentDataType.STRING, (Object)player.getUniqueId().toString());
    }
}

