/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor.core.events;

import io.github.greatericontop.greatimpostor.GreatImpostorMain;
import io.github.greatericontop.greatimpostor.core.profiles.PlayerProfile;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class DeadChatHandler
implements Listener {
    private final GreatImpostorMain plugin;

    public DeadChatHandler(GreatImpostorMain plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onDeadChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        PlayerProfile profile = this.plugin.playerProfiles.get(player.getUniqueId());
        if (profile == null || profile.isAlive()) {
            return;
        }
        event.setFormat("\u00a77[DEAD CHAT]\u00a7r " + event.getFormat());
        for (PlayerProfile recipientProfile : this.plugin.playerProfiles.values()) {
            if (!recipientProfile.isAlive()) continue;
            try {
                event.getRecipients().remove(recipientProfile.getPlayer());
            }
            catch (UnsupportedOperationException e) {
                player.sendMessage("\u00a7cDue to a problem with the server, you can't send chat messages while dead. Sorry!");
                event.setCancelled(true);
            }
        }
    }
}

