/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor.core.events;

import io.github.greatericontop.greatimpostor.GreatImpostorMain;
import io.github.greatericontop.greatimpostor.core.profiles.PlayerProfile;
import io.github.greatericontop.greatimpostor.task.sabotage.Sabotage;
import io.github.greatericontop.greatimpostor.utils.ImpostorUtil;
import java.time.Duration;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class BodyReportingListener
implements Listener {
    private static final double REPORT_DIST = 4.0;
    private final GreatImpostorMain plugin;

    public BodyReportingListener(GreatImpostorMain plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onRightClickReportButton(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getItem() == null) {
            return;
        }
        ItemMeta im = event.getItem().getItemMeta();
        if (im == null) {
            return;
        }
        if (im.getPersistentDataContainer().has(ImpostorUtil.REPORT_KEY, PersistentDataType.INTEGER)) {
            Player player = event.getPlayer();
            PlayerProfile profile = this.plugin.playerProfiles.get(player.getUniqueId());
            if (profile == null) {
                player.sendMessage("\u00a7cCouldn't get your profile!");
                return;
            }
            if (!profile.isAlive()) {
                player.sendMessage("\u00a7cYou're dead! You can't report a body!");
                return;
            }
            if (this.plugin.sabotageManager.shouldRemoveWhenBodyReported()) {
                this.plugin.sabotageManager.forceEndSabotage();
            }
            if (this.plugin.sabotageManager.getActiveSabotage() == Sabotage.COMMUNICATIONS && this.plugin.getConfig().getBoolean("comms-sabotage-prevents-reporting")) {
                player.sendMessage("\u00a7cCommunications are down!");
                return;
            }
            boolean noBodyFound = true;
            for (Entity entity : player.getNearbyEntities(4.0, 4.0, 4.0)) {
                ArmorStand armorStand;
                if (!(entity instanceof ArmorStand) || !(armorStand = (ArmorStand)entity).getPersistentDataContainer().has(ImpostorUtil.DEAD_BODY_KEY, PersistentDataType.INTEGER)) continue;
                armorStand.remove();
                player.sendMessage("\u00a73Successfully reported!");
                for (Player p : Bukkit.getOnlinePlayers()) {
                    p.showTitle(Title.title((Component)Component.text((String)"\u00a7cDead Body Reported"), (Component)Component.text((String)("\u00a76" + player.getName() + " reported a body!")), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(1500L), (Duration)Duration.ofMillis(5000L), (Duration)Duration.ofMillis(1500L))));
                }
                this.plugin.meetingManager.startNewMeeting(false);
                noBodyFound = false;
                break;
            }
            if (noBodyFound) {
                player.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
                player.sendMessage("\u00a73No dead body close to you was found!");
            }
        }
    }
}

