/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor.core;

import io.github.greatericontop.greatimpostor.GreatImpostorMain;
import io.github.greatericontop.greatimpostor.core.profiles.CrewmateProfile;
import io.github.greatericontop.greatimpostor.core.profiles.ImpostorProfile;
import io.github.greatericontop.greatimpostor.core.profiles.PlayerProfile;
import io.github.greatericontop.greatimpostor.pathfinding.MapGraph;
import io.github.greatericontop.greatimpostor.pathfinding.XYZ;
import io.github.greatericontop.greatimpostor.utils.CooldownResetReason;
import io.github.greatericontop.greatimpostor.utils.PlayerColor;
import io.github.greatericontop.greatimpostor.utils.Shuffler;
import java.time.Duration;
import java.util.Collection;
import java.util.Random;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class StartGame {
    public static void startGame(final GreatImpostorMain plugin, int numberImpostors, final @Nullable Player responsiblePlayer) {
        Random random = new Random();
        Collection playersRaw = Bukkit.getOnlinePlayers();
        Object[] players = playersRaw.toArray(new Player[0]);
        Shuffler.shuffle(players, random);
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        Team team = scoreboard.getTeam("greatimpostor_players");
        if (team == null) {
            team = scoreboard.registerNewTeam("greatimpostor_players");
        }
        team.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
        team.addEntities((Entity[])players);
        plugin.gameManager.showAllPlayers();
        PlayerColor[] colors = PlayerColor.values();
        Shuffler.shuffle((Object[])colors, random);
        if (players.length > colors.length) {
            if (responsiblePlayer != null) {
                responsiblePlayer.sendMessage("\u00a7cToo many players for the available number of player colors!");
            }
            return;
        }
        plugin.taskAnalyzeSample.resetSelf();
        responsiblePlayer.sendMessage("\u00a77Generating data structures for pathfinding...");
        long start = System.currentTimeMillis();
        XYZ startVertex = new XYZ(plugin.getStartingLocation().getBlockX(), plugin.getStartingLocation().getBlockY(), plugin.getStartingLocation().getBlockZ());
        plugin.mapGraph = new MapGraph(plugin);
        plugin.mapGraph.generate(plugin.getStartingLocation().getWorld(), startVertex);
        plugin.mapGraph.findSignsInGraph(plugin.getStartingLocation().getWorld());
        for (String s : plugin.mapGraph.messages) {
            responsiblePlayer.sendMessage("\u00a77" + s);
        }
        responsiblePlayer.sendMessage(String.format("\u00a77Finished setting up pathfinding in %dms!", System.currentTimeMillis() - start));
        for (int i = 0; i < players.length; ++i) {
            String subtitle;
            String title;
            PlayerProfile newProfile;
            Object currentPlayer = players[i];
            if (i < numberImpostors) {
                newProfile = new ImpostorProfile(plugin, (Player)currentPlayer, colors[i]);
                title = "\u00a7cIMPOSTOR";
                subtitle = "\u00a7eKill off the crew!";
            } else {
                newProfile = new CrewmateProfile(plugin, (Player)currentPlayer, colors[i]);
                title = "\u00a7bCREWMATE";
                subtitle = "\u00a7eDo your tasks and find the impostor!";
            }
            plugin.playerProfiles.put(currentPlayer.getUniqueId(), newProfile);
            currentPlayer.getInventory().clear();
            currentPlayer.setGameMode(GameMode.ADVENTURE);
            currentPlayer.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 80, 0));
            currentPlayer.teleport(plugin.getStartingLocation());
            currentPlayer.showTitle(Title.title((Component)Component.text((String)title), (Component)Component.text((String)subtitle), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(1000L), (Duration)Duration.ofMillis(3000L), (Duration)Duration.ofMillis(2000L))));
            currentPlayer.playSound(currentPlayer.getLocation(), Sound.ENTITY_WITHER_DEATH, 1.0f, 1.0f);
            currentPlayer.sendMessage(String.format("\u00a7bYour color is: \u00a73[%s\u00a73]\u00a7b.", colors[i].getDisplayName()));
        }
        new BukkitRunnable(){

            public void run() {
                if (responsiblePlayer != null) {
                    responsiblePlayer.sendMessage("\u00a77Removing old dead bodies. If your server has too many entities, it might lag for a few seconds.");
                }
                long start = System.currentTimeMillis();
                int amount = plugin.gameManager.removeAllBodiesAndFakePlayers();
                if (responsiblePlayer != null) {
                    responsiblePlayer.sendMessage(String.format("\u00a77Finished removing %d dead bodies in %d ms.", amount, System.currentTimeMillis() - start));
                }
            }
        }.runTaskLater((Plugin)plugin, 5L);
        new BukkitRunnable(){
            int i = 4;

            public void run() {
                if (this.i <= 0) {
                    this.cancel();
                    return;
                }
                if (this.i > 1) {
                    Bukkit.broadcast((Component)Component.text((String)String.format("\u00a7eGame will begin in \u00a7b%d \u00a7eseconds!", this.i - 1)));
                }
                for (Player p : Bukkit.getOnlinePlayers()) {
                    p.teleport(plugin.getStartingLocation());
                }
                --this.i;
            }
        }.runTaskTimer((Plugin)plugin, 20L, 20L);
        new BukkitRunnable(){

            public void run() {
                for (PlayerProfile profile : plugin.playerProfiles.values()) {
                    profile.setInitialTasks();
                    profile.setInventory();
                    profile.getPlayer().getInventory().setHeldItemSlot(0);
                    if (!profile.isImpostor()) continue;
                    ImpostorProfile impostorProfile = (ImpostorProfile)profile;
                    impostorProfile.resetKillCooldown(CooldownResetReason.GAME_START);
                    impostorProfile.getPlayer().chat("/impostor listimpostors _showhint_");
                }
                plugin.gameManager.resetAllSabotageCooldowns(CooldownResetReason.GAME_START);
            }
        }.runTaskLater((Plugin)plugin, 80L);
    }
}

