/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor.core;

import io.github.greatericontop.greatimpostor.GreatImpostorMain;
import io.github.greatericontop.greatimpostor.core.profiles.ImpostorProfile;
import io.github.greatericontop.greatimpostor.core.profiles.PlayerProfile;
import io.github.greatericontop.greatimpostor.task.sabotage.Sabotage;
import io.github.greatericontop.greatimpostor.utils.CooldownResetReason;
import io.github.greatericontop.greatimpostor.utils.ImpostorUtil;
import io.github.greatericontop.greatimpostor.utils.PartialCoordinates;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class GameManager {
    private boolean inventoryChangeRequested;
    private List<List<PartialCoordinates>> vents = null;
    private final GreatImpostorMain plugin;

    public GameManager(GreatImpostorMain plugin) {
        this.plugin = plugin;
    }

    public void requestInventoryChange() {
        this.inventoryChangeRequested = true;
    }

    public void resetAllSabotageCooldowns(CooldownResetReason reason) {
        for (PlayerProfile profile : this.plugin.playerProfiles.values()) {
            if (!profile.isImpostor()) continue;
            ImpostorProfile impostorProfile = (ImpostorProfile)profile;
            impostorProfile.resetSabotageCooldownSelfOnly(reason);
        }
    }

    public void registerGameRunnable() {
        new BukkitRunnable(){

            public void run() {
                GameManager.this.plugin.sabotageManager.tickSabotages();
                if (GameManager.this.inventoryChangeRequested) {
                    for (PlayerProfile profile : GameManager.this.plugin.playerProfiles.values()) {
                        profile.setInventory();
                    }
                    GameManager.this.inventoryChangeRequested = false;
                }
                for (PlayerProfile profile : GameManager.this.plugin.playerProfiles.values()) {
                    Player player = profile.getPlayer();
                    if (profile.isImpostor()) {
                        ImpostorProfile impostorProfile = (ImpostorProfile)profile;
                        impostorProfile.tickCooldowns();
                        GameManager.this.plugin.ventManager.setBackVentedImpostor(impostorProfile);
                    }
                    GameManager.this.plugin.securityCameraManager.setBackSecurityCameraPlayer(profile);
                    if (profile.isInCameras) {
                        if (GameManager.this.plugin.sabotageManager.getActiveSabotage() == Sabotage.COMMUNICATIONS) {
                            player.sendMessage("\u00a7cCommunications sabotaged!");
                            GameManager.this.plugin.securityCameraManager.exitCameras(profile, player);
                        }
                        player.addPotionEffect(new PotionEffect(PotionEffectType.DARKNESS, 600, 0, false, false, false));
                    } else {
                        player.removePotionEffect(PotionEffectType.DARKNESS);
                    }
                    player.setFoodLevel(GameManager.this.plugin.sabotageManager.getActiveSabotage() == Sabotage.LIGHTS ? 6 : 20);
                    if (!profile.isAlive()) {
                        player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 5, 0, false, false, false));
                        player.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, 5, 0, false, false, false));
                    }
                    if (GameManager.this.plugin.meetingManager.isMeetingActive()) {
                        GameManager.this.plugin.meetingManager.setMeetingActionBar(profile.getPlayer());
                        continue;
                    }
                    profile.setActionBar();
                }
                GameManager.this.checkGameFinished();
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }

    private void checkGameFinished() {
        if (this.plugin.playerProfiles.size() == 0) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("enable-victory-checks")) {
            return;
        }
        int[] taskStatus = PlayerProfile.getTaskStatus(this.plugin.playerProfiles.values());
        if (taskStatus[1] > 0 && taskStatus[0] == taskStatus[1]) {
            this.endGame("\u00a7bCrewmates win! \u00a7aAll tasks were completed!");
            return;
        }
        if (this.getAliveImpostorCount() == 0) {
            this.endGame("\u00a7bCrewmates win! \u00a7aNo impostors left!");
            return;
        }
        if (this.getAliveImpostorCount() >= this.getAliveCrewCount()) {
            this.endGame("\u00a7cImpostors win! \u00a7aToo many crewmates died!");
            return;
        }
    }

    private int getAliveImpostorCount() {
        int aliveImpostors = 0;
        for (PlayerProfile profile : this.plugin.playerProfiles.values()) {
            if (!profile.isImpostor() || !profile.isAlive()) continue;
            ++aliveImpostors;
        }
        return aliveImpostors;
    }

    private int getAliveCrewCount() {
        int aliveCrew = 0;
        for (PlayerProfile profile : this.plugin.playerProfiles.values()) {
            if (profile.isImpostor() || !profile.isAlive()) continue;
            ++aliveCrew;
        }
        return aliveCrew;
    }

    public void endGame(String message) {
        Bukkit.broadcast((Component)Component.text((String)"\u00a79--------------------------------------------------"));
        Bukkit.broadcast((Component)Component.text((String)""));
        Bukkit.broadcast((Component)Component.text((String)message));
        Bukkit.broadcast((Component)Component.text((String)""));
        Bukkit.broadcast((Component)Component.text((String)"\u00a79--------------------------------------------------"));
        this.plugin.playerProfiles.clear();
        this.showAllPlayers();
        this.plugin.meetingManager.killMeeting();
        for (Player p : Bukkit.getOnlinePlayers()) {
            p.teleport(p.getWorld().getSpawnLocation());
            p.setGameMode(Bukkit.getDefaultGameMode());
        }
    }

    public void loadVents() {
        this.vents = new ArrayList<List<PartialCoordinates>>();
        this.plugin.getConfig().getList("vents").forEach(ventSystem -> {
            List convertedVentSystem = (List)ventSystem;
            ArrayList ventSystemList = new ArrayList(convertedVentSystem.size());
            convertedVentSystem.forEach(vent -> ventSystemList.add(PartialCoordinates.fromConfigEntry(vent)));
            this.vents.add(ventSystemList);
        });
    }

    public int[] findVentSystem(PartialCoordinates coordinates) {
        for (int system = 0; system < this.vents.size(); ++system) {
            for (int individualVent = 0; individualVent < this.vents.get(system).size(); ++individualVent) {
                if (!this.vents.get(system).get(individualVent).isClose(coordinates)) continue;
                return new int[]{system, individualVent};
            }
        }
        return null;
    }

    public int getVentCount(int system) {
        return this.vents.get(system).size();
    }

    public PartialCoordinates getVent(int ventSystem, int ventNumber) {
        return this.vents.get(ventSystem).get(ventNumber);
    }

    public void showAllPlayers() {
        for (Player p1 : Bukkit.getOnlinePlayers()) {
            for (Player p2 : Bukkit.getOnlinePlayers()) {
                if (p1.equals(p2)) continue;
                p1.showPlayer((Plugin)this.plugin, p2);
            }
        }
    }

    public int removeAllBodiesAndFakePlayers() {
        int amount = 0;
        for (Entity entity : this.plugin.getStartingLocation().getWorld().getEntities()) {
            ArmorStand armorStand;
            if (!(entity instanceof ArmorStand) || !(armorStand = (ArmorStand)entity).getPersistentDataContainer().has(ImpostorUtil.DEAD_BODY_KEY, PersistentDataType.INTEGER) && !armorStand.getPersistentDataContainer().has(ImpostorUtil.FAKE_PLAYER_KEY, PersistentDataType.STRING)) continue;
            armorStand.remove();
            ++amount;
        }
        return amount;
    }
}

