/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatimpostor;

import io.github.greatericontop.greatimpostor.DebugImpostorCommand;
import io.github.greatericontop.greatimpostor.GreatImpostorMain;
import io.github.greatericontop.greatimpostor.core.StartGame;
import io.github.greatericontop.greatimpostor.core.profiles.ImpostorProfile;
import io.github.greatericontop.greatimpostor.core.profiles.PlayerProfile;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class ImpostorCommand
implements CommandExecutor,
TabCompleter {
    private final GreatImpostorMain plugin;

    public ImpostorCommand(GreatImpostorMain plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            return false;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage("\u00a7cYou must be a player to use this command!");
            return true;
        }
        Player player = (Player)sender;
        if (args[0].equals("tutorial")) {
            player.openBook(Book.book((Component)Component.text((String)"Tutorial"), (Component)Component.text((String)"GreatImpostor"), (Component[])new Component[]{Component.text((String)"\u00a7dWelcome to GreatImpostor!\n\n\n\u00a70This is a tutorial to help you start."), Component.text((String)"\u00a73\u00a7lCREWMATE\n\n\n\u00a70Do your tasks!\n\nYou'll have 4 pieces of glass indicating what tasks to do. Check their names to see what room to go to and what to do. They'll change color as you complete them."), Component.text((String)"\u00a70Right click signs to interact with them.\n\n\u00a70You can vote during meetings using \u00a76/vote\u00a70."), Component.text((String)"\u00a70Right click the horn to report a body.\n\nYou'll win if everyone finishes their tasks, or if the impostors are found and ejected."), Component.text((String)"\u00a70If you can't find the room, look around, and there should be directions on the walls."), Component.text((String)"\u00a7c\u00a7lIMPOSTOR\n\n\n\u00a70Kill everyone!\n\nAttack a crewmate with the sword to kill them."), Component.text((String)"\u00a76HOTKEY \u00a70to the TNT to choose a sabotage, and \u00a76HOTKEY \u00a70to the redstone to activate it.\n\n\u00a76SNEAK \u00a70over a vent to use it. Then \u00a76JUMP \u00a70to move around or \u00a76SNEAK \u00a70again to exit."), Component.text((String)"\u00a70You'll win if you kill enough crewmates, or if the crew fails to repair a sabotage.")}));
            return true;
        }
        if (args[0].equals("start")) {
            if (!player.hasPermission("impostor.admin")) {
                player.sendMessage("\u00a7cYou need \u00a76impostor.admin \u00a7cto access these commands!");
                return true;
            }
            int impostorCount = 1;
            if (args.length >= 2) {
                try {
                    impostorCount = Integer.parseInt(args[1]);
                    StartGame.startGame(this.plugin, impostorCount, player);
                    return true;
                }
                catch (NumberFormatException e) {
                    player.sendMessage("\u00a7cInvalid number of players specified!");
                    return true;
                }
            }
            StartGame.startGame(this.plugin, impostorCount, player);
            return true;
        }
        if (args[0].equals("config")) {
            if (args.length == 1) {
                player.sendMessage("\u00a79--------------------------------------------------");
                player.sendMessage("\u00a7bGame Config");
                player.sendMessage("");
                int meetingTimeTicks = this.plugin.getConfig().getInt("meeting-time-ticks");
                player.sendMessage(Component.text((String)String.format("\u00a73Meeting time: \u00a7e%d\u00a73t    ", meetingTimeTicks)).append(Component.text((String)"\u00a77[edit]").clickEvent(ClickEvent.suggestCommand((String)String.format("/impostor config meeting-time-ticks %d", meetingTimeTicks)))));
                int criticalSabotageFixTicks = this.plugin.getConfig().getInt("critical-sabotage-fix-ticks");
                player.sendMessage(Component.text((String)String.format("\u00a73Critical sabotage fix time: \u00a7e%d\u00a73t    ", criticalSabotageFixTicks)).append(Component.text((String)"\u00a77[edit]").clickEvent(ClickEvent.suggestCommand((String)String.format("/impostor config critical-sabotage-fix-ticks %d", criticalSabotageFixTicks)))));
                int maxMeetingsPerPlayer = this.plugin.getConfig().getInt("max-meetings-per-player");
                player.sendMessage(Component.text((String)String.format("\u00a73Max meetings per player: \u00a7e%d\u00a73    ", maxMeetingsPerPlayer)).append(Component.text((String)"\u00a77[edit]").clickEvent(ClickEvent.suggestCommand((String)String.format("/impostor config max-meetings-per-player %d", maxMeetingsPerPlayer)))));
                boolean commsSabotagePreventsReporting = this.plugin.getConfig().getBoolean("comms-sabotage-prevents-reporting");
                player.sendMessage(Component.text((String)String.format("\u00a73Comms sabotage prevents reporting: \u00a7e%s\u00a73    ", commsSabotagePreventsReporting)).append(Component.text((String)"\u00a77[edit]").clickEvent(ClickEvent.suggestCommand((String)String.format("/impostor config comms-sabotage-prevents-reporting %s", !commsSabotagePreventsReporting)))));
                player.sendMessage("");
                int cooldownKillGameStart = this.plugin.getConfig().getInt("impostor-cooldowns.kill-game-start");
                player.sendMessage(Component.text((String)String.format("\u00a73Cooldown kill (game start): \u00a7e%d\u00a73t    ", cooldownKillGameStart)).append(Component.text((String)"\u00a77[edit]").clickEvent(ClickEvent.suggestCommand((String)String.format("/impostor config cooldowns.kill-game-start %d", cooldownKillGameStart)))));
                int cooldownSabotageGameStart = this.plugin.getConfig().getInt("impostor-cooldowns.sabotage-game-start");
                player.sendMessage(Component.text((String)String.format("\u00a73Cooldown sabotage (game start): \u00a7e%d\u00a73t    ", cooldownSabotageGameStart)).append(Component.text((String)"\u00a77[edit]").clickEvent(ClickEvent.suggestCommand((String)String.format("/impostor config cooldowns.sabotage-game-start %d", cooldownSabotageGameStart)))));
                int cooldownKillAfterUse = this.plugin.getConfig().getInt("impostor-cooldowns.kill-after-use");
                player.sendMessage(Component.text((String)String.format("\u00a73Cooldown kill (after use): \u00a7e%d\u00a73t    ", cooldownKillAfterUse)).append(Component.text((String)"\u00a77[edit]").clickEvent(ClickEvent.suggestCommand((String)String.format("/impostor config cooldowns.kill-after-use %d", cooldownKillAfterUse)))));
                int cooldownSabotageAfterUse = this.plugin.getConfig().getInt("impostor-cooldowns.sabotage-after-use");
                player.sendMessage(Component.text((String)String.format("\u00a73Cooldown sabotage (after use): \u00a7e%d\u00a73t    ", cooldownSabotageAfterUse)).append(Component.text((String)"\u00a77[edit]").clickEvent(ClickEvent.suggestCommand((String)String.format("/impostor config cooldowns.sabotage-after-use %d", cooldownSabotageAfterUse)))));
                int cooldownKillAfterMeeting = this.plugin.getConfig().getInt("impostor-cooldowns.kill-after-meeting");
                player.sendMessage(Component.text((String)String.format("\u00a73Cooldown kill (after meeting): \u00a7e%d\u00a73t    ", cooldownKillAfterMeeting)).append(Component.text((String)"\u00a77[edit]").clickEvent(ClickEvent.suggestCommand((String)String.format("/impostor config cooldowns.kill-after-meeting %d", cooldownKillAfterMeeting)))));
                int cooldownSabotageAfterMeeting = this.plugin.getConfig().getInt("impostor-cooldowns.sabotage-after-meeting");
                player.sendMessage(Component.text((String)String.format("\u00a73Cooldown sabotage (after meeting): \u00a7e%d\u00a73t    ", cooldownSabotageAfterMeeting)).append(Component.text((String)"\u00a77[edit]").clickEvent(ClickEvent.suggestCommand((String)String.format("/impostor config cooldowns.sabotage-after-meeting %d", cooldownSabotageAfterMeeting)))));
                player.sendMessage("\u00a79--------------------------------------------------");
                return true;
            }
            if (args[1].equals("meeting-time-ticks") || args[1].equals("critical-sabotage-fix-ticks") || args[1].equals("max-meetings-per-player") || args[1].equals("cooldowns.kill-game-start") || args[1].equals("cooldowns.sabotage-game-start") || args[1].equals("cooldowns.kill-after-use") || args[1].equals("cooldowns.sabotage-after-use") || args[1].equals("cooldowns.kill-after-meeting") || args[1].equals("cooldowns.sabotage-after-meeting")) {
                int value;
                if (args.length == 2) {
                    player.sendMessage("\u00a7cSpecify a value!");
                    return true;
                }
                try {
                    value = Integer.parseInt(args[2]);
                }
                catch (NumberFormatException e) {
                    player.sendMessage("\u00a7cInvalid number specified!");
                    return true;
                }
                if (value <= 0) {
                    player.sendMessage("\u00a7cValue must be positive!");
                    return true;
                }
                if (args[1].startsWith("cooldowns.")) {
                    args[1] = args[1].replace("cooldowns.", "impostor-cooldowns.");
                }
                this.plugin.getConfig().set(args[1], (Object)value);
                this.plugin.saveConfig();
                player.sendMessage(String.format("\u00a73Successfully set \u00a7b%s \u00a73to \u00a7b%d.", args[1], value));
                return true;
            }
            if (args[1].equals("comms-sabotage-prevents-reporting")) {
                boolean value;
                if (args.length == 2) {
                    player.sendMessage("\u00a7cSpecify a value!");
                    return true;
                }
                if (args[2].equalsIgnoreCase("true")) {
                    value = true;
                } else if (args[2].equalsIgnoreCase("false")) {
                    value = false;
                } else {
                    player.sendMessage("\u00a7cInvalid value specified! Use 'true' or 'false'.");
                    return true;
                }
                this.plugin.getConfig().set(args[1], (Object)value);
                this.plugin.saveConfig();
                player.sendMessage(String.format("\u00a73Successfully set \u00a7b%s \u00a73to \u00a7b%s.", args[1], value));
                return true;
            }
            player.sendMessage("\u00a7cThat's not an option!");
            return true;
        }
        if (args[0].equals("listimpostors")) {
            PlayerProfile profile = this.plugin.playerProfiles.get(player.getUniqueId());
            if (profile == null) {
                player.sendMessage("\u00a7cYou are not in a game!");
                return true;
            }
            if (!(profile instanceof ImpostorProfile)) {
                player.sendMessage("\u00a7cYou can only use this command as an impostor!");
                return true;
            }
            ArrayList<String> impostorNames = new ArrayList<String>();
            for (PlayerProfile p : this.plugin.playerProfiles.values()) {
                if (!(p instanceof ImpostorProfile) || profile.equals(p)) continue;
                impostorNames.add(String.format("\u00a7c%s\u00a73", p.getPlayer().getName()));
            }
            if (impostorNames.isEmpty()) {
                player.sendMessage("\u00a73You are the only impostor!");
            } else {
                player.sendMessage(String.format("\u00a73Your Fellow Impostors: %s", String.join((CharSequence)", ", impostorNames)));
                if (args.length > 1 && args[1].equals("_showhint_")) {
                    player.sendMessage("\u00a73Use \u00a7b/impostor listimpostors \u00a7cto show this message again.");
                }
            }
            return true;
        }
        if (args[0].equals("debug")) {
            if (!player.hasPermission("impostor.admin")) {
                player.sendMessage("\u00a7cYou need \u00a76impostor.admin \u00a7cto access these commands!");
                return true;
            }
            String[] newArgs = new String[args.length - 1];
            System.arraycopy(args, 1, newArgs, 0, args.length - 1);
            new DebugImpostorCommand(this.plugin).onCommand(sender, command, label, newArgs);
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1) {
            return List.of("start", "tutorial", "config", "listimpostors", "debug");
        }
        if (args.length == 2 && args[0].equals("start")) {
            return List.of("<number of impostors>");
        }
        if (args.length >= 2 && args[0].equals("config")) {
            if (args.length == 2) {
                return List.of("meeting-time-ticks", "critical-sabotage-fix-ticks", "max-meetings-per-player", "comms-sabotage-prevents-reporting", "cooldowns.kill-game-start", "cooldowns.sabotage-game-start", "cooldowns.kill-after-use", "cooldowns.sabotage-after-use", "cooldowns.kill-after-meeting", "cooldowns.sabotage-after-meeting");
            }
            if (args[1].equals("meeting-time-ticks") || args[1].equals("critical-sabotage-fix-ticks") || args[1].equals("max-meetings-per-player") || args[1].equals("cooldowns.kill-game-start") || args[1].equals("cooldowns.sabotage-game-start") || args[1].equals("cooldowns.kill-after-use") || args[1].equals("cooldowns.sabotage-after-use") || args[1].equals("cooldowns.kill-after-meeting") || args[1].equals("cooldowns.sabotage-after-meeting")) {
                return List.of("<integer>");
            }
            if (args[1].equals("comms-sabotage-prevents-reporting")) {
                return List.of("true", "false");
            }
            return List.of();
        }
        return List.of();
    }
}

