/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatcrafts.updatechecker;

import com.google.gson.Gson;
import io.github.greatericontop.greatcrafts.updatechecker.ModrinthVersion;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import javax.annotation.Nullable;
import org.bukkit.plugin.Plugin;

public class UpdateChecker {
    @Nullable
    public static String getLatestVersion(Plugin plugin) {
        HttpResponse<String> response;
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create("http://api.modrinth.com/v2/project/greatcrafts/version")).header("User-Agent", "greatericontop/GreatCrafts").GET().build();
        HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).build();
        try {
            response = client.send(request, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException e) {
            plugin.getLogger().warning("Update checker failed: " + e.getMessage());
            return null;
        }
        if (response.statusCode() != 200) {
            plugin.getLogger().warning("Update checker failed, HTTP status code " + response.statusCode());
            plugin.getLogger().warning(response.body());
            return null;
        }
        Gson gson = new Gson();
        ModrinthVersion[] versions = (ModrinthVersion[])gson.fromJson(response.body(), ModrinthVersion[].class);
        return versions[0].version_number().split("---")[0];
    }
}

