/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatcrafts.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class Util {
    private static final int LINES = 5;
    private static final int PER_LINE = 4;

    public static ItemStack createItemStack(Material mat, int amount, String name, String ... lore) {
        return Util.createItemStack(mat, amount, name, Arrays.asList(lore));
    }

    public static ItemStack createItemStack(Material mat, int amount, String name, List<String> lore) {
        ItemStack stack = new ItemStack(mat, amount);
        ItemMeta im = stack.getItemMeta();
        im.setDisplayName(name);
        im.setLore(lore);
        stack.setItemMeta(im);
        return stack;
    }

    public static ItemStack createItemStackWithPDC(Material mat, int amount, NamespacedKey key, PersistentDataType dtype, Object value, String name, String ... lore) {
        ItemStack stack = new ItemStack(mat, amount);
        ItemMeta im = stack.getItemMeta();
        im.setDisplayName(name);
        im.getPersistentDataContainer().set(key, dtype, value);
        im.setLore(Arrays.asList(lore));
        stack.setItemMeta(im);
        return stack;
    }

    public static void appendLore(ItemMeta im, String ... moreLore) {
        ArrayList<String> lore = im.getLore();
        if (lore == null) {
            lore = new ArrayList<String>();
        }
        lore.addAll(Arrays.asList(moreLore));
        im.setLore(lore);
    }

    public static void successSound(Player player) {
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.0f);
    }

    public static List<List<Material>> defaultMaterialChoiceExtra() {
        ArrayList<List<Material>> list = new ArrayList<List<Material>>();
        for (int i = 0; i < 9; ++i) {
            list.add(new ArrayList());
        }
        return list;
    }

    public static ItemStack renderMaterialChoiceIcon(List<Material> items, boolean showEditTooltip) {
        ArrayList<String> lore = new ArrayList<String>();
        if (showEditTooltip) {
            lore.add("\u00a7eSHIFT RIGHT CLICK \u00a7fto edit!");
            lore.add("\u00a7dThis is a placeholder item. It is not actually in the recipe. Removing");
            lore.add("\u00a7dthis item from this menu does not have any effect.");
        }
        lore.add("\u00a77Items:");
        int numLines = Math.min(5, (int)Math.ceil((double)items.size() / 4.0));
        for (int line = 0; line < numLines; ++line) {
            int indexStart = line * 4;
            CharSequence[] names = new String[Math.min(4, items.size() - indexStart)];
            for (int j = 0; j < names.length; ++j) {
                names[j] = items.get(indexStart + j).name().toLowerCase().replace('_', ' ');
            }
            String itemsDisplay = "\u00a7f" + String.join((CharSequence)"\u00a77;\u00a7f  ", names);
            if (line == 4 && items.size() > 20) {
                itemsDisplay = itemsDisplay + "\u00a77;\u00a7f  ...";
            }
            if (line != numLines - 1) {
                itemsDisplay = itemsDisplay + "\u00a77;";
            }
            lore.add(itemsDisplay);
        }
        return Util.createItemStack(Material.END_PORTAL_FRAME, 1, "\u00a7bMaterial Choice", lore);
    }

    public static int performShiftClickCraft(Player player, ItemStack result, int maxCraftsAvailable) {
        int actualAmountCrafted = 0;
        while (maxCraftsAvailable > 0) {
            HashMap unadded = player.getInventory().addItem(new ItemStack[]{result.clone()});
            if (!unadded.isEmpty()) {
                if (unadded.size() != 1) {
                    throw new RuntimeException();
                }
                if (!unadded.containsKey(0)) {
                    throw new RuntimeException();
                }
                ItemStack failedToAdd = (ItemStack)unadded.get(0);
                if (failedToAdd.getAmount() == result.getAmount()) break;
                player.getWorld().dropItemNaturally(player.getLocation(), failedToAdd);
                ++actualAmountCrafted;
                --maxCraftsAvailable;
                break;
            }
            ++actualAmountCrafted;
            --maxCraftsAvailable;
        }
        return actualAmountCrafted;
    }
}

