/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatcrafts.internal;

import io.github.greatericontop.greatcrafts.GreatCrafts;
import io.github.greatericontop.greatcrafts.internal.datastructures.IngredientType;
import io.github.greatericontop.greatcrafts.internal.datastructures.RecipeType;
import io.github.greatericontop.greatcrafts.internal.datastructures.SavedRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;

public class RecipeManager {
    private final GreatCrafts plugin;

    public RecipeManager(GreatCrafts plugin) {
        this.plugin = plugin;
    }

    public List<SavedRecipe> getAllSavedRecipes() {
        Set keys = this.plugin.recipes.getKeys(false);
        ArrayList<SavedRecipe> allRecipes = new ArrayList<SavedRecipe>();
        for (String key : keys) {
            allRecipes.add(this.getRecipe(key));
        }
        return allRecipes;
    }

    public boolean isRecipeCustom(String key) {
        return this.plugin.recipes.contains(key);
    }

    public SavedRecipe getRecipe(String key) {
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        String string = this.plugin.recipes.getString(key);
        if (string == null) {
            return null;
        }
        try {
            yamlConfiguration.loadFromString(string);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("failed to load yaml configuration from string, see stack trace above");
        }
        SavedRecipe savedRec = this.deserializeSavedRecipe((List)yamlConfiguration.get("shapedrecipe"));
        if (!savedRec.key().toString().equals(key)) {
            throw new RuntimeException(String.format("Malformed config; key mismatch! Key requested %s, key found in savedRec %s", key, savedRec.key()));
        }
        return savedRec;
    }

    public void setRecipe(String key, SavedRecipe recipe) {
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        yamlConfiguration.set("shapedrecipe", this.serializeSavedRecipe(recipe));
        this.plugin.recipes.set(key, (Object)yamlConfiguration.saveToString());
    }

    public boolean tryDeleteRecipe(String key) {
        if (this.plugin.recipes.contains(key)) {
            this.plugin.recipes.set(key, null);
            Bukkit.removeRecipe((NamespacedKey)NamespacedKey.fromString((String)key));
            return true;
        }
        return false;
    }

    public List<Object> serializeSavedRecipe(SavedRecipe recipe) {
        ArrayList<Object> serialized = new ArrayList<Object>();
        serialized.add(recipe.key().getNamespace());
        serialized.add(recipe.key().getKey());
        serialized.add(recipe.items());
        serialized.add(recipe.result());
        ArrayList<String> convertedIngredientTypes = new ArrayList<String>();
        for (IngredientType ingredientType : recipe.ingredientTypes()) {
            convertedIngredientTypes.add(ingredientType.toString());
        }
        serialized.add(convertedIngredientTypes);
        ArrayList materialChoiceStrings = new ArrayList();
        for (List<Material> originalList : recipe.materialChoiceExtra()) {
            ArrayList<String> newList = new ArrayList<String>();
            for (Material material : originalList) {
                newList.add(material.toString());
            }
            materialChoiceStrings.add(newList);
        }
        serialized.add(materialChoiceStrings);
        serialized.add(recipe.iconItem());
        serialized.add(recipe.type().toString());
        return serialized;
    }

    public SavedRecipe deserializeSavedRecipe(List<Object> serialized) {
        String namespace = (String)serialized.get(0);
        String key = (String)serialized.get(1);
        NamespacedKey nameKey = new NamespacedKey(namespace, key);
        List items = (List)serialized.get(2);
        ItemStack result = (ItemStack)serialized.get(3);
        List ingredientTypesRaw = (List)serialized.get(4);
        IngredientType[] ingredientTypes = new IngredientType[9];
        for (int i = 0; i < 9; ++i) {
            ingredientTypes[i] = IngredientType.valueOf((String)ingredientTypesRaw.get(i));
        }
        List materialChoiceStrings = (List)serialized.get(5);
        ArrayList<List<Material>> materialChoiceExtra = new ArrayList<List<Material>>();
        for (List originalList : materialChoiceStrings) {
            ArrayList<Material> newList = new ArrayList<Material>();
            for (String materialString : originalList) {
                newList.add(Material.valueOf((String)materialString));
            }
            materialChoiceExtra.add(newList);
        }
        ItemStack iconItem = (ItemStack)serialized.get(6);
        RecipeType type = RecipeType.valueOf((String)serialized.get(7));
        return new SavedRecipe(nameKey, type, items, result, ingredientTypes, materialChoiceExtra, iconItem);
    }
}

