/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatcrafts.internal;

import io.github.greatericontop.greatcrafts.internal.ShapeAnalyzer;
import io.github.greatericontop.greatcrafts.internal.datastructures.IngredientType;
import io.github.greatericontop.greatcrafts.internal.datastructures.SavedRecipe;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class RecipeLoader {
    public static void compileAndAddRecipe(SavedRecipe recipe, @Nullable CommandSender commandSender) {
        switch (recipe.type()) {
            case SHAPED: {
                RecipeLoader.compileAndAddShapedRecipe(recipe);
                break;
            }
            case SHAPELESS: {
                RecipeLoader.compileAndAddShapelessRecipe(recipe);
                break;
            }
            case STACKED_ITEMS: {
                RecipeLoader.compileAndAddStackedItemsRecipe(recipe, commandSender);
                break;
            }
            case STACKED_ITEMS_SHAPELESS: {
                RecipeLoader.compileAndAddStackedItemsShapelessRecipe(recipe, commandSender);
            }
        }
    }

    private static void compileAndAddShapedRecipe(SavedRecipe shapedSavedRecipe) {
        char symbol;
        int i;
        ShapedRecipe shapedRecipe = new ShapedRecipe(shapedSavedRecipe.key(), shapedSavedRecipe.result());
        List<ItemStack> slots = shapedSavedRecipe.items();
        for (int i2 = 0; i2 < 9; ++i2) {
            if (shapedSavedRecipe.ingredientTypes()[i2] != IngredientType.MATERIAL_CHOICE) continue;
            if (shapedSavedRecipe.materialChoiceExtra().get(i2).isEmpty()) {
                slots.set(i2, null);
                continue;
            }
            slots.set(i2, new ItemStack(Material.END_PORTAL_FRAME));
        }
        char[] layout = "         ".toCharArray();
        for (i = 0; i < 9; ++i) {
            if (slots.get(i) == null || slots.get(i).getType() == Material.AIR) continue;
            layout[i] = symbol = (char)(97 + i);
        }
        shapedRecipe.shape(new String[]{new String(new char[]{layout[0], layout[1], layout[2]}), new String(new char[]{layout[3], layout[4], layout[5]}), new String(new char[]{layout[6], layout[7], layout[8]})});
        block7: for (i = 0; i < 9; ++i) {
            if (slots.get(i) == null || slots.get(i).getType() == Material.AIR) continue;
            symbol = (char)(97 + i);
            switch (shapedSavedRecipe.ingredientTypes()[i]) {
                case NORMAL: {
                    shapedRecipe.setIngredient(symbol, slots.get(i).getType());
                    continue block7;
                }
                case EXACT_CHOICE: {
                    RecipeChoice.ExactChoice exactChoice = new RecipeChoice.ExactChoice(slots.get(i));
                    shapedRecipe.setIngredient(symbol, (RecipeChoice)exactChoice);
                    continue block7;
                }
                case MATERIAL_CHOICE: {
                    RecipeChoice.MaterialChoice materialChoice = new RecipeChoice.MaterialChoice(shapedSavedRecipe.materialChoiceExtra().get(i));
                    shapedRecipe.setIngredient(symbol, (RecipeChoice)materialChoice);
                    continue block7;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        String[] newShape = ShapeAnalyzer.shrink(shapedRecipe.getShape());
        shapedRecipe.shape(newShape);
        Bukkit.addRecipe((Recipe)shapedRecipe);
    }

    private static void compileAndAddShapelessRecipe(SavedRecipe shapelessSavedRecipe) {
        int i;
        ShapelessRecipe shapelessRec = new ShapelessRecipe(shapelessSavedRecipe.key(), shapelessSavedRecipe.result());
        List<ItemStack> slots = shapelessSavedRecipe.items();
        for (i = 0; i < 9; ++i) {
            if (shapelessSavedRecipe.ingredientTypes()[i] != IngredientType.MATERIAL_CHOICE) continue;
            if (shapelessSavedRecipe.materialChoiceExtra().get(i).isEmpty()) {
                slots.set(i, null);
                continue;
            }
            slots.set(i, new ItemStack(Material.END_PORTAL_FRAME));
        }
        block6: for (i = 0; i < 9; ++i) {
            if (slots.get(i) == null || slots.get(i).getType() == Material.AIR) continue;
            switch (shapelessSavedRecipe.ingredientTypes()[i]) {
                case NORMAL: {
                    shapelessRec.addIngredient(slots.get(i).getType());
                    continue block6;
                }
                case EXACT_CHOICE: {
                    RecipeChoice.ExactChoice exactChoice = new RecipeChoice.ExactChoice(slots.get(i));
                    shapelessRec.addIngredient((RecipeChoice)exactChoice);
                    continue block6;
                }
                case MATERIAL_CHOICE: {
                    RecipeChoice.MaterialChoice materialChoice = new RecipeChoice.MaterialChoice(shapelessSavedRecipe.materialChoiceExtra().get(i));
                    shapelessRec.addIngredient((RecipeChoice)materialChoice);
                    continue block6;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        Bukkit.addRecipe((Recipe)shapelessRec);
    }

    private static void compileAndAddStackedItemsRecipe(SavedRecipe shapedSavedRecipe, @Nullable CommandSender commandSender) {
        char symbol;
        int i;
        ShapedRecipe shapedRecipe = new ShapedRecipe(shapedSavedRecipe.key(), shapedSavedRecipe.result());
        List<ItemStack> slots = shapedSavedRecipe.items();
        for (int i2 = 0; i2 < 9; ++i2) {
            if (shapedSavedRecipe.ingredientTypes()[i2] != IngredientType.MATERIAL_CHOICE) continue;
            if (shapedSavedRecipe.materialChoiceExtra().get(i2).isEmpty()) {
                slots.set(i2, null);
                continue;
            }
            slots.set(i2, new ItemStack(Material.END_PORTAL_FRAME, 64));
        }
        char[] layout = "         ".toCharArray();
        for (i = 0; i < 9; ++i) {
            if (slots.get(i) == null || slots.get(i).getType() == Material.AIR) continue;
            layout[i] = symbol = (char)(97 + i);
        }
        shapedRecipe.shape(new String[]{new String(new char[]{layout[0], layout[1], layout[2]}), new String(new char[]{layout[3], layout[4], layout[5]}), new String(new char[]{layout[6], layout[7], layout[8]})});
        block7: for (i = 0; i < 9; ++i) {
            if (slots.get(i) == null || slots.get(i).getType() == Material.AIR) continue;
            symbol = (char)(97 + i);
            switch (shapedSavedRecipe.ingredientTypes()[i]) {
                case NORMAL: {
                    shapedRecipe.setIngredient(symbol, slots.get(i).getType());
                    continue block7;
                }
                case EXACT_CHOICE: {
                    RecipeChoice.ExactChoice exactChoice = new RecipeChoice.ExactChoice(slots.get(i));
                    shapedRecipe.setIngredient(symbol, (RecipeChoice)exactChoice);
                    continue block7;
                }
                case MATERIAL_CHOICE: {
                    shapedRecipe.setIngredient(symbol, slots.get(i).getType());
                    if (commandSender == null) continue block7;
                    commandSender.sendMessage("\u00a7c(" + String.valueOf(shapedSavedRecipe.key()) + ") material choice used in a stacked items craft!");
                    continue block7;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        String[] newShape = ShapeAnalyzer.shrink(shapedRecipe.getShape());
        shapedRecipe.shape(newShape);
        Bukkit.addRecipe((Recipe)shapedRecipe);
    }

    private static void compileAndAddStackedItemsShapelessRecipe(SavedRecipe shapelessSavedRecipe, @Nullable CommandSender commandSender) {
        int i;
        ShapelessRecipe shapelessRec = new ShapelessRecipe(shapelessSavedRecipe.key(), shapelessSavedRecipe.result());
        List<ItemStack> slots = shapelessSavedRecipe.items();
        for (i = 0; i < 9; ++i) {
            if (shapelessSavedRecipe.ingredientTypes()[i] != IngredientType.MATERIAL_CHOICE) continue;
            if (shapelessSavedRecipe.materialChoiceExtra().get(i).isEmpty()) {
                slots.set(i, null);
                continue;
            }
            slots.set(i, new ItemStack(Material.END_PORTAL_FRAME, 64));
        }
        block6: for (i = 0; i < 9; ++i) {
            if (slots.get(i) == null || slots.get(i).getType() == Material.AIR) continue;
            switch (shapelessSavedRecipe.ingredientTypes()[i]) {
                case NORMAL: {
                    shapelessRec.addIngredient(slots.get(i).getType());
                    continue block6;
                }
                case EXACT_CHOICE: {
                    RecipeChoice.ExactChoice exactChoice = new RecipeChoice.ExactChoice(slots.get(i));
                    shapelessRec.addIngredient((RecipeChoice)exactChoice);
                    continue block6;
                }
                case MATERIAL_CHOICE: {
                    shapelessRec.addIngredient(slots.get(i).getType());
                    if (commandSender == null) continue block6;
                    commandSender.sendMessage("\u00a7c(" + String.valueOf(shapelessSavedRecipe.key()) + ") material choice used in a stacked items craft!");
                    continue block6;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        Bukkit.addRecipe((Recipe)shapelessRec);
    }
}

