/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatcrafts.internal;

import io.github.greatericontop.greatcrafts.GreatCrafts;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class CraftLimitDataManager {
    private static final String DATAFILE = "craft_counts_save.yml";

    public static Map<UUID, Map<String, Integer>> fromYamlConfiguration(GreatCrafts plugin) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)new File(plugin.getDataFolder(), DATAFILE));
        HashMap<UUID, Map<String, Integer>> playerCraftCounts = new HashMap<UUID, Map<String, Integer>>();
        for (String key : config.getKeys(false)) {
            UUID uuid = UUID.fromString(key);
            HashMap<String, Integer> craftCounts = new HashMap<String, Integer>();
            ConfigurationSection section = config.getConfigurationSection(key);
            for (String craftKey : section.getKeys(false)) {
                int count = section.getInt(craftKey);
                craftCounts.put(craftKey, count);
            }
            playerCraftCounts.put(uuid, craftCounts);
        }
        return playerCraftCounts;
    }

    public static void saveToYamlConfiguration(GreatCrafts plugin, Map<UUID, Map<String, Integer>> playerCraftCounts) {
        YamlConfiguration config = new YamlConfiguration();
        for (Map.Entry<UUID, Map<String, Integer>> entry : playerCraftCounts.entrySet()) {
            UUID uuid = entry.getKey();
            Map<String, Integer> craftCounts = entry.getValue();
            ConfigurationSection section = config.createSection(uuid.toString());
            for (Map.Entry<String, Integer> craftEntry : craftCounts.entrySet()) {
                section.set(craftEntry.getKey(), (Object)craftEntry.getValue());
            }
        }
        try {
            config.save(new File(plugin.getDataFolder(), DATAFILE));
        }
        catch (IOException e) {
            plugin.getLogger().severe("Failed to save craft counts due to IOException");
            e.printStackTrace();
        }
    }
}

