/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatcrafts.gui;

import io.github.greatericontop.greatcrafts.GreatCrafts;
import io.github.greatericontop.greatcrafts.internal.Util;
import io.github.greatericontop.greatcrafts.internal.datastructures.SavedRecipe;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class RecipeListMenu
implements Listener {
    private static final String INV_NAME = "\u00a73Recipes";
    private static final int PREV_PAGE_SLOT = 45;
    private static final int INDICATOR_SLOT = 49;
    private static final int NEXT_PAGE_SLOT = 53;
    private static final int CRAFTS_PER_PAGE = 36;
    private final NamespacedKey recipeKeyPDC;
    private final NamespacedKey pageNumberIndicatorPDC;
    private final NamespacedKey searchQueryPDC;
    private final GreatCrafts plugin;

    public RecipeListMenu(GreatCrafts plugin) {
        this.plugin = plugin;
        this.recipeKeyPDC = new NamespacedKey((Plugin)plugin, "recipeKey");
        this.pageNumberIndicatorPDC = new NamespacedKey((Plugin)plugin, "pageNumberIndicator");
        this.searchQueryPDC = new NamespacedKey((Plugin)plugin, "searchQuery");
    }

    private void updateInventory(Player player, List<SavedRecipe> allRecipes, Inventory gui, int visualPageNumber, boolean shouldLookupSearchQuery, @Nullable String searchQuery) {
        ItemMeta im;
        if (shouldLookupSearchQuery) {
            searchQuery = (String)gui.getItem(49).getItemMeta().getPersistentDataContainer().get(this.searchQueryPDC, PersistentDataType.STRING);
        }
        int indexStart = 36 * (visualPageNumber - 1);
        for (int i = 0; i < 54; ++i) {
            gui.setItem(i, null);
        }
        String finalSearchQuery = searchQuery;
        Stream<SavedRecipe> allViewableRecipes = allRecipes.stream().filter(r -> this.plugin.recipePermissionRequirements.get(r.key().toString()) == null || player.hasPermission(this.plugin.recipePermissionRequirements.get(r.key().toString())));
        List<SavedRecipe> searchResults = searchQuery == null ? allViewableRecipes.toList() : allViewableRecipes.filter(savedRecipe -> savedRecipe.key().toString().contains(finalSearchQuery)).toList();
        for (int i = indexStart; i < indexStart + 36 && i < searchResults.size(); ++i) {
            SavedRecipe savedRecipe2 = searchResults.get(i);
            ItemStack icon = savedRecipe2.iconItem();
            im = icon.getItemMeta();
            ItemStack resultItem = savedRecipe2.result();
            String resultName = resultItem.hasItemMeta() && resultItem.getItemMeta().hasDisplayName() ? resultItem.getItemMeta().getDisplayName() : resultItem.getType().getKey().getKey();
            String resultDisplay = String.format("  \u00a7f%s \u00a77x\u00a7f%d%s", resultName, resultItem.getAmount(), resultItem.hasItemMeta() ? " \u00a77(+NBT)" : "");
            im.getPersistentDataContainer().set(this.recipeKeyPDC, PersistentDataType.STRING, (Object)savedRecipe2.key().toString());
            Util.appendLore(im, "", "", "\u00a7dResult item:", resultDisplay, "\u00a7dKey:", "  \u00a77" + String.valueOf(savedRecipe2.key()));
            icon.setItemMeta(im);
            gui.setItem(i % 36, icon);
        }
        int totalPages = (int)Math.ceil((double)searchResults.size() / 36.0);
        if (visualPageNumber != 1) {
            ItemStack prevPage = Util.createItemStack(Material.ARROW, 1, "\u00a7fPrevious Page", new String[0]);
            gui.setItem(45, prevPage);
        }
        if (visualPageNumber != totalPages) {
            ItemStack nextPage = Util.createItemStack(Material.ARROW, 1, "\u00a7fNext Page", new String[0]);
            gui.setItem(53, nextPage);
        }
        Object searchQueryLine = searchQuery == null ? "\u00a77Showing all recipes" : "\u00a77Currently searching for: \u00a7f" + searchQuery;
        ItemStack nextPage = Util.createItemStack(Material.PAPER, 1, String.format("\u00a76Page \u00a7e%d \u00a76/ \u00a7e%d", visualPageNumber, totalPages), new String[]{"\u00a73Left click to view, right click to edit", searchQueryLine, "\u00a78You can use \u00a77/recipes <search keyword> \u00a78to", "\u00a78search for specific recipes!"});
        im = nextPage.getItemMeta();
        im.getPersistentDataContainer().set(this.pageNumberIndicatorPDC, PersistentDataType.INTEGER, (Object)visualPageNumber);
        if (searchQuery != null) {
            im.getPersistentDataContainer().set(this.searchQueryPDC, PersistentDataType.STRING, (Object)searchQuery);
        }
        nextPage.setItemMeta(im);
        gui.setItem(49, nextPage);
    }

    public void openNew(Player player, String searchQuery) {
        List<SavedRecipe> allRecipes = this.plugin.recipeManager.getAllSavedRecipes();
        if (allRecipes.isEmpty()) {
            this.plugin.languager.commandErrorRecipeListEmpty((CommandSender)player);
            return;
        }
        if (searchQuery != null && allRecipes.stream().filter(savedRecipe -> savedRecipe.key().toString().contains(searchQuery)).toList().isEmpty()) {
            this.plugin.languager.commandErrorRecipeListNothingMatches((CommandSender)player);
            return;
        }
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)INV_NAME);
        this.updateInventory(player, allRecipes, gui, 1, false, searchQuery);
        player.openInventory(gui);
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        Inventory gui = event.getClickedInventory();
        if (gui == null) {
            return;
        }
        if (!event.getView().getTitle().equals(INV_NAME)) {
            return;
        }
        event.setCancelled(true);
        if (!event.getView().getTopInventory().equals(event.getClickedInventory())) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        int slot = event.getSlot();
        if (slot == 45) {
            if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            int pageNum = (Integer)gui.getItem(49).getItemMeta().getPersistentDataContainer().get(this.pageNumberIndicatorPDC, PersistentDataType.INTEGER);
            List<SavedRecipe> allRecipes = this.plugin.recipeManager.getAllSavedRecipes();
            this.updateInventory(player, allRecipes, gui, pageNum - 1, true, null);
        } else if (slot == 53) {
            if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            int pageNum = (Integer)gui.getItem(49).getItemMeta().getPersistentDataContainer().get(this.pageNumberIndicatorPDC, PersistentDataType.INTEGER);
            List<SavedRecipe> allRecipes = this.plugin.recipeManager.getAllSavedRecipes();
            this.updateInventory(player, allRecipes, gui, pageNum + 1, true, null);
        } else if (slot < 36) {
            ItemStack itemClicked = event.getCurrentItem();
            if (itemClicked == null || itemClicked.getType() == Material.AIR) {
                return;
            }
            ItemMeta im = itemClicked.getItemMeta();
            String recipeKey = (String)im.getPersistentDataContainer().get(this.recipeKeyPDC, PersistentDataType.STRING);
            player.closeInventory();
            if (event.getClick() == ClickType.RIGHT) {
                player.chat(String.format("/editrecipe %s", recipeKey));
            } else {
                player.chat(String.format("/viewrecipe %s", recipeKey));
            }
        }
    }
}

