/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatcrafts.gui;

import io.github.greatericontop.greatcrafts.gui.GUIManager;
import io.github.greatericontop.greatcrafts.internal.Util;
import io.github.greatericontop.greatcrafts.internal.datastructures.IngredientType;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class MaterialChoiceToggler
implements Listener {
    private static final String INV_NAME = "\u00a7bToggle Material Choice";
    private final GUIManager guiManager;

    public MaterialChoiceToggler(GUIManager guiManager) {
        this.guiManager = guiManager;
    }

    public void openNew(Player player, int slotNumber) {
        String descriptionText;
        Map<String, Object> internalData = this.guiManager.guiData.get(player.getUniqueId());
        IngredientType currentType = ((IngredientType[])internalData.get("ingredientTypes"))[slotNumber];
        String editText = switch (currentType) {
            case IngredientType.NORMAL -> {
                descriptionText = "\u00a7fMaterial Choice is currently \u00a74OFF";
                yield "\u00a7aEnable and Edit";
            }
            case IngredientType.EXACT_CHOICE -> {
                descriptionText = "\u00a7fMaterial Choice is currently \u00a74OFF\u00a7f, but Material Choice is on";
                yield "\u00a7aEnable and Edit \u00a77(disables Exact Choice)";
            }
            case IngredientType.MATERIAL_CHOICE -> {
                descriptionText = "\u00a7fMaterial Choice is currently \u00a72ON";
                yield "\u00a7aEdit";
            }
            default -> throw new RuntimeException();
        };
        Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)9, (String)INV_NAME);
        if (currentType == IngredientType.MATERIAL_CHOICE) {
            gui.setItem(0, Util.createItemStack(Material.RED_STAINED_GLASS, 1, "\u00a7cDisable", new String[0]));
        }
        gui.setItem(4, Util.createItemStack(Material.ENCHANTED_BOOK, 1, descriptionText, new String[0]));
        gui.setItem(8, Util.createItemStack(Material.LIME_STAINED_GLASS, 1, editText, new String[0]));
        player.openInventory(gui);
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        Inventory gui = event.getClickedInventory();
        if (gui == null) {
            return;
        }
        if (!event.getView().getTitle().equals(INV_NAME)) {
            return;
        }
        if (!event.getView().getTopInventory().equals(event.getClickedInventory())) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Map<String, Object> internalData = this.guiManager.guiData.get(player.getUniqueId());
        int slotNumber = (Integer)internalData.get("currentSlot");
        if (event.getSlot() == 0) {
            IngredientType[] types = (IngredientType[])internalData.get("ingredientTypes");
            if (types[slotNumber] == IngredientType.MATERIAL_CHOICE) {
                types[slotNumber] = IngredientType.NORMAL;
                Util.successSound(player);
                player.closeInventory();
            } else {
                event.setCancelled(true);
            }
        } else if (event.getSlot() == 8) {
            ((IngredientType[])internalData.get((Object)"ingredientTypes"))[slotNumber] = IngredientType.MATERIAL_CHOICE;
            Util.successSound(player);
            Inventory save = this.guiManager.playerMainInventories.get(player.getUniqueId());
            this.guiManager.playerMainInventories.remove(player.getUniqueId());
            player.closeInventory();
            this.guiManager.playerMainInventories.put(player.getUniqueId(), save);
            this.guiManager.getPlugin().guiMaterialChoiceEditor.openNew(player);
        } else {
            event.setCancelled(true);
        }
    }
}

