/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatcrafts.gui;

import io.github.greatericontop.greatcrafts.gui.GUIManager;
import io.github.greatericontop.greatcrafts.internal.Util;
import io.github.greatericontop.greatcrafts.internal.datastructures.IngredientType;
import io.github.greatericontop.greatcrafts.internal.datastructures.SavedRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class MaterialChoiceEditor
implements Listener {
    private static final String INV_NAME = "\u00a7bEdit Material Choice Items";
    private final GUIManager guiManager;

    public MaterialChoiceEditor(GUIManager guiManager) {
        this.guiManager = guiManager;
    }

    public void openNew(Player player) {
        Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)INV_NAME);
        gui.setItem(51, Util.createItemStack(Material.ENCHANTED_BOOK, 1, INV_NAME, "\u00a7fPlace items in any of the 51 other slots of this inventory.", "\u00a7fFor this slot, \u00a7eany \u00a7fitem placed here (no exact match needed) can be used."));
        gui.setItem(52, Util.createItemStack(Material.RED_STAINED_GLASS, 1, "\u00a7cDiscard Changes", new String[0]));
        gui.setItem(53, Util.createItemStack(Material.LIME_STAINED_GLASS, 1, "\u00a7aSave Changes", new String[0]));
        Map<String, Object> internalData = this.guiManager.guiData.get(player.getUniqueId());
        int slotNumber = (Integer)internalData.get("currentSlot");
        List materialChoices = (List)((List)internalData.get("materialChoiceExtra")).get(slotNumber);
        for (int i = 0; i < materialChoices.size(); ++i) {
            gui.setItem(i, new ItemStack((Material)materialChoices.get(i), 1));
        }
        player.openInventory(gui);
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        Inventory gui = event.getClickedInventory();
        if (gui == null) {
            return;
        }
        if (!event.getView().getTitle().equals(INV_NAME)) {
            return;
        }
        if (!event.getView().getTopInventory().equals(event.getClickedInventory())) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Map<String, Object> internalData = this.guiManager.guiData.get(player.getUniqueId());
        int recipeSlotNum = (Integer)internalData.get("currentSlot");
        if (event.getSlot() == 51) {
            event.setCancelled(true);
        } else if (event.getSlot() == 52) {
            player.closeInventory();
        } else if (event.getSlot() == 53) {
            ArrayList<Material> materialChoiceList = new ArrayList<Material>();
            for (int i = 0; i <= 50; ++i) {
                ItemStack stack = gui.getItem(i);
                if (stack == null || stack.getType() == Material.AIR || materialChoiceList.contains(stack.getType())) continue;
                materialChoiceList.add(stack.getType());
            }
            ((List)internalData.get("materialChoiceExtra")).set(recipeSlotNum, materialChoiceList);
            this.guiManager.getPlugin().guiCraftEditor.fillCraftingSlot(recipeSlotNum, this.guiManager.playerMainInventories.get(player.getUniqueId()), (SavedRecipe)internalData.get("recipe"), (IngredientType[])internalData.get("ingredientTypes"), (List)internalData.get("materialChoiceExtra"));
            Util.successSound(player);
            player.closeInventory();
        }
    }
}

