/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatcrafts.gui;

import io.github.greatericontop.greatcrafts.gui.GUIManager;
import io.github.greatericontop.greatcrafts.internal.Util;
import io.github.greatericontop.greatcrafts.internal.datastructures.IngredientType;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class ExactChoiceToggler
implements Listener {
    private static final String INV_NAME = "\u00a7bToggle Exact Choice";
    private final GUIManager guiManager;

    public ExactChoiceToggler(GUIManager guiManager) {
        this.guiManager = guiManager;
    }

    public void openNew(Player player, int slotNumber) {
        String toggleText;
        String descriptionText;
        Map<String, Object> internalData = this.guiManager.guiData.get(player.getUniqueId());
        IngredientType currentType = ((IngredientType[])internalData.get("ingredientTypes"))[slotNumber];
        Material toggleMaterial = switch (currentType) {
            case IngredientType.NORMAL -> {
                descriptionText = "\u00a7fExact Choice is currently \u00a74OFF";
                toggleText = "\u00a7aEnable";
                yield Material.LIME_STAINED_GLASS;
            }
            case IngredientType.EXACT_CHOICE -> {
                descriptionText = "\u00a7fExact Choice is currently \u00a72ON";
                toggleText = "\u00a7cDisable";
                yield Material.RED_STAINED_GLASS;
            }
            case IngredientType.MATERIAL_CHOICE -> {
                descriptionText = "\u00a7fExact Choice is currently \u00a74OFF\u00a7f, but Material Choice is on";
                toggleText = "\u00a7aEnable \u00a77(disables Material Choice)";
                yield Material.LIME_STAINED_GLASS;
            }
            default -> throw new RuntimeException();
        };
        Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)9, (String)INV_NAME);
        gui.setItem(4, Util.createItemStack(Material.ENCHANTED_BOOK, 1, descriptionText, new String[0]));
        gui.setItem(8, Util.createItemStack(toggleMaterial, 1, toggleText, new String[0]));
        player.openInventory(gui);
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        Inventory gui = event.getClickedInventory();
        if (gui == null) {
            return;
        }
        if (!event.getView().getTitle().equals(INV_NAME)) {
            return;
        }
        if (!event.getView().getTopInventory().equals(event.getClickedInventory())) {
            return;
        }
        if (event.getSlot() != 8) {
            event.setCancelled(true);
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Map<String, Object> internalData = this.guiManager.guiData.get(player.getUniqueId());
        int slotNumber = (Integer)internalData.get("currentSlot");
        IngredientType currentType = ((IngredientType[])internalData.get("ingredientTypes"))[slotNumber];
        ((IngredientType[])internalData.get((Object)"ingredientTypes"))[slotNumber] = switch (currentType) {
            case IngredientType.NORMAL, IngredientType.MATERIAL_CHOICE -> IngredientType.EXACT_CHOICE;
            case IngredientType.EXACT_CHOICE -> IngredientType.NORMAL;
            default -> throw new RuntimeException();
        };
        Util.successSound(player);
        player.closeInventory();
    }
}

