/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatcrafts.gui;

import io.github.greatericontop.greatcrafts.gui.GUIManager;
import io.github.greatericontop.greatcrafts.internal.Util;
import io.github.greatericontop.greatcrafts.internal.datastructures.IngredientType;
import io.github.greatericontop.greatcrafts.internal.datastructures.RecipeType;
import io.github.greatericontop.greatcrafts.internal.datastructures.SavedRecipe;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class CraftReadOnlyViewer
implements Listener {
    private static final String INV_NAME = "\u00a7bView Crafting Recipe";
    private static final int SLOT1 = 10;
    private static final int SLOT2 = 11;
    private static final int SLOT3 = 12;
    private static final int SLOT4 = 19;
    private static final int SLOT5 = 20;
    private static final int SLOT6 = 21;
    private static final int SLOT7 = 28;
    private static final int SLOT8 = 29;
    private static final int SLOT9 = 30;
    private static final int SLOT_RESULT = 23;
    private static final int SLOT_RECIPE_LIST = 45;
    private static final int SLOT_EDIT = 53;
    private final GUIManager guiManager;
    private final NamespacedKey recipeKeyPDC;

    public CraftReadOnlyViewer(GUIManager guiManager) {
        this.guiManager = guiManager;
        this.recipeKeyPDC = new NamespacedKey((Plugin)guiManager.getPlugin(), "recipeKey");
    }

    public void openNew(Player player, String craftKey) {
        SavedRecipe savedRecipe = this.guiManager.getRecipeManager().getRecipe(craftKey);
        if (savedRecipe == null) {
            this.guiManager.getPlugin().languager.commandErrorRecipeNotExist((CommandSender)player, craftKey);
            return;
        }
        Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)INV_NAME);
        for (int i = 0; i < 54; ++i) {
            gui.setItem(i, new ItemStack(Material.BLACK_STAINED_GLASS_PANE, 1));
        }
        this.fillViewCraftingSlots(gui, savedRecipe, savedRecipe.ingredientTypes(), savedRecipe.materialChoiceExtra());
        gui.setItem(23, savedRecipe.result());
        gui.setItem(45, Util.createItemStack(Material.ENCHANTED_BOOK, 1, "\u00a7aRecipe List \u00a7eCLICK HERE", new String[0]));
        if (player.hasPermission("greatcrafts.modifyrecipes")) {
            gui.setItem(53, Util.createItemStackWithPDC(Material.WRITABLE_BOOK, 1, this.recipeKeyPDC, PersistentDataType.STRING, savedRecipe.key().toString(), "\u00a7aEdit \u00a7eCLICK HERE", new String[0]));
        }
        player.openInventory(gui);
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        Player player;
        Inventory gui = event.getClickedInventory();
        if (gui == null) {
            return;
        }
        if (!event.getView().getTitle().equals(INV_NAME)) {
            return;
        }
        event.setCancelled(true);
        if (event.getSlot() == 45) {
            player = (Player)event.getWhoClicked();
            player.closeInventory();
            player.chat("/recipes");
        }
        if (event.getSlot() == 53 && event.getCurrentItem().getType() != Material.BLACK_STAINED_GLASS_PANE) {
            player = (Player)event.getWhoClicked();
            String recipeKey = (String)event.getCurrentItem().getItemMeta().getPersistentDataContainer().get(this.recipeKeyPDC, PersistentDataType.STRING);
            player.closeInventory();
            player.chat(String.format("/editrecipe %s", recipeKey));
        }
    }

    private void fillViewCraftingSlots(Inventory gui, SavedRecipe recipe, IngredientType[] ingredientTypes, List<List<Material>> materialChoiceExtra) {
        int[] SLOTS = new int[]{10, 11, 12, 19, 20, 21, 28, 29, 30};
        block5: for (int i = 0; i < 9; ++i) {
            switch (ingredientTypes[i]) {
                case NORMAL: {
                    if (recipe.items().get(i) == null) {
                        gui.setItem(SLOTS[i], null);
                        continue block5;
                    }
                    gui.setItem(SLOTS[i], new ItemStack(recipe.items().get(i).getType(), recipe.items().get(i).getAmount()));
                    continue block5;
                }
                case EXACT_CHOICE: {
                    gui.setItem(SLOTS[i], recipe.items().get(i));
                    continue block5;
                }
                case MATERIAL_CHOICE: {
                    if (recipe.type() == RecipeType.STACKED_ITEMS) {
                        gui.setItem(SLOTS[i], Util.createItemStack(Material.END_PORTAL_FRAME, 64, "\u00a7cMaterial Choice", "\u00a7fMaterial choice is unsupported! Please fix this recipe!"));
                        continue block5;
                    }
                    gui.setItem(SLOTS[i], Util.renderMaterialChoiceIcon(materialChoiceExtra.get(i), false));
                }
            }
        }
    }
}

