/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatcrafts.gui;

import io.github.greatericontop.greatcrafts.gui.GUIManager;
import io.github.greatericontop.greatcrafts.internal.RecipeLoader;
import io.github.greatericontop.greatcrafts.internal.Util;
import io.github.greatericontop.greatcrafts.internal.datastructures.IngredientType;
import io.github.greatericontop.greatcrafts.internal.datastructures.RecipeType;
import io.github.greatericontop.greatcrafts.internal.datastructures.SavedRecipe;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class CraftEditor
implements Listener {
    private static final String INV_NAME = "\u00a7bEdit Craft";
    private static final int SLOT1 = 10;
    private static final int SLOT2 = 11;
    private static final int SLOT3 = 12;
    private static final int SLOT4 = 19;
    private static final int SLOT5 = 20;
    private static final int SLOT6 = 21;
    private static final int SLOT7 = 28;
    private static final int SLOT8 = 29;
    private static final int SLOT9 = 30;
    private static final int SLOT_RESULT = 23;
    private static final int SLOT_ICON = 16;
    private static final int SLOT_CHANGE_TYPE = 26;
    private static final int SLOT_HOWTO = 45;
    private static final int SLOT_DELETER = 46;
    private static final int SLOT_EXTRA_INFO = 48;
    private static final int SLOT_DISCARD = 51;
    private static final int SLOT_SAVE = 52;
    private static final int SLOT_SAVE_AND_ACTIVATE = 53;
    private static final Set<Integer> VALID_CLICK_SLOTS = Set.of(10, 11, 12, 19, 20, 21, 28, 29, 30, 23, 16, 26, 46, 48, 51, 52, 53);
    private static final Map<Integer, Integer> SLOT_INDEXER = Map.of(10, 0, 11, 1, 12, 2, 19, 3, 20, 4, 21, 5, 28, 6, 29, 7, 30, 8);
    private final GUIManager guiManager;

    public CraftEditor(GUIManager guiManager) {
        this.guiManager = guiManager;
    }

    public void openNew(Player player, String craftKey) {
        SavedRecipe savedRecipe = this.guiManager.getRecipeManager().getRecipe(craftKey);
        Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)INV_NAME);
        for (int i = 0; i < 54; ++i) {
            gui.setItem(i, new ItemStack(Material.BLACK_STAINED_GLASS_PANE, 1));
        }
        this.fillCraftingSlots(gui, savedRecipe, savedRecipe.ingredientTypes(), savedRecipe.materialChoiceExtra());
        gui.setItem(23, savedRecipe.result());
        gui.setItem(16, savedRecipe.iconItem());
        gui.setItem(45, Util.createItemStack(Material.ENCHANTED_BOOK, 1, "\u00a7bHow To", "\u00a77Place items in the grid, result, and icon slots.", "\u00a7eSHIFT LEFT CLICK \u00a77to toggle \u00a7fexact choice \u00a77(exact NBT)", "\u00a7eSHIFT RIGHT CLICK \u00a77to toggle \u00a7fmaterial choice \u00a77(multiple items)", "\u00a77Click on the crafting table icon to change the recipe type.", "\u00a77Discard, save, or save and activate your changes."));
        String autoUnlockSetting = this.guiManager.getPlugin().autoUnlockExceptions.containsKey(craftKey) ? String.format("\u00a7e%s \u00a77(set)", new Object[]{this.guiManager.getPlugin().autoUnlockExceptions.get(craftKey)}) : String.format("\u00a7e%s \u00a77(plugin-wide default setting)", new Object[]{this.guiManager.getPlugin().autoUnlockSetting});
        String permissionReq = this.guiManager.getPlugin().recipePermissionRequirements.containsKey(craftKey) ? String.format("\u00a7e%s", this.guiManager.getPlugin().recipePermissionRequirements.getOrDefault(craftKey, null)) : "\u00a77(none)";
        String craftingLimit = this.guiManager.getPlugin().recipeCraftingLimits.containsKey(craftKey) ? String.format("\u00a7e%d \u00a77(per player, stacked items only)", this.guiManager.getPlugin().recipeCraftingLimits.get(craftKey)) : "\u00a77(unlimited)";
        gui.setItem(48, Util.createItemStack(Material.MAP, 1, "\u00a7bExtra Settings", "\u00a76auto unlock setting\u00a77: " + autoUnlockSetting, "\u00a76permission requirement\u00a77: " + permissionReq, "\u00a76crafting limit\u00a77: " + craftingLimit, "", "\u00a7aClick to edit", String.format("\u00a7aOr use \u00a77/editrecipe %s show-settings", craftKey)));
        gui.setItem(46, Util.createItemStack(Material.REDSTONE, 1, "\u00a7cItem Deleter", "\u00a77Place items here to delete them without dropping them on the ground."));
        gui.setItem(26, this.getDisplayItemStackForRecipeType(savedRecipe.type()));
        gui.setItem(51, Util.createItemStack(Material.BARRIER, 1, "\u00a7cDiscard Changes", new String[0]));
        gui.setItem(52, Util.createItemStack(Material.LIME_STAINED_GLASS, 1, "\u00a7aSave Changes", "\u00a77Your changes will not take effect until you /reloadrecipes."));
        gui.setItem(53, Util.createItemStack(Material.LIME_CONCRETE, 1, "\u00a7aSave & Activate Changes", "\u00a7fThis reloads the current recipe and applies the changes immediately.", "\u00a7eNote: \u00a7fPlayers still need to reconnect to see the recipe client-side, but it will work on the server.", "\u00a77You can also use \u00a7e/reloadrecipes \u00a77to reload all recipes."));
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("recipe", savedRecipe);
        data.put("type", (Object)savedRecipe.type());
        data.put("ingredientTypes", savedRecipe.ingredientTypes());
        data.put("materialChoiceExtra", savedRecipe.materialChoiceExtra());
        this.guiManager.guiData.put(player.getUniqueId(), data);
        this.guiManager.playerMainInventories.put(player.getUniqueId(), gui);
        player.openInventory(gui);
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        Inventory gui = event.getClickedInventory();
        if (gui == null) {
            return;
        }
        if (!event.getView().getTitle().equals(INV_NAME)) {
            return;
        }
        if (!event.getView().getTopInventory().equals(event.getClickedInventory())) {
            return;
        }
        int slot = event.getSlot();
        if (!VALID_CLICK_SLOTS.contains(slot)) {
            event.setCancelled(true);
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Map<String, Object> data = this.guiManager.guiData.get(player.getUniqueId());
        if (slot == 26) {
            RecipeType currentType = (RecipeType)((Object)data.get("type"));
            RecipeType newType = switch (currentType) {
                default -> throw new IncompatibleClassChangeError();
                case RecipeType.SHAPED -> RecipeType.SHAPELESS;
                case RecipeType.SHAPELESS -> RecipeType.STACKED_ITEMS;
                case RecipeType.STACKED_ITEMS -> RecipeType.STACKED_ITEMS_SHAPELESS;
                case RecipeType.STACKED_ITEMS_SHAPELESS -> RecipeType.SHAPED;
            };
            data.put("type", (Object)newType);
            gui.setItem(26, this.getDisplayItemStackForRecipeType(newType));
            event.setCancelled(true);
        }
        if (slot == 46) {
            player.setItemOnCursor(null);
            event.setCancelled(true);
        }
        if (slot == 48) {
            player.performCommand(String.format("editrecipe %s show-settings", ((SavedRecipe)data.get("recipe")).key()));
            event.setCancelled(true);
        }
        if (slot == 51 || slot == 52 || slot == 53) {
            if (slot == 52 || slot == 53) {
                SavedRecipe oldRecipe = (SavedRecipe)data.get("recipe");
                SavedRecipe newRecipe = this.saveIntoNewRecipe(gui, oldRecipe.key(), data);
                this.guiManager.getRecipeManager().setRecipe(oldRecipe.key().toString(), newRecipe);
                if (slot == 53) {
                    Bukkit.removeRecipe((NamespacedKey)newRecipe.key());
                    RecipeLoader.compileAndAddRecipe(newRecipe, (CommandSender)player);
                }
                Util.successSound(player);
            }
            this.guiManager.guiData.remove(player.getUniqueId());
            this.guiManager.playerMainInventories.remove(player.getUniqueId());
            player.closeInventory();
        }
        if (SLOT_INDEXER.containsKey(slot)) {
            int index = SLOT_INDEXER.get(slot);
            if (event.getClick() == ClickType.SHIFT_LEFT) {
                save = this.guiManager.playerMainInventories.get(player.getUniqueId());
                this.guiManager.playerMainInventories.remove(player.getUniqueId());
                player.closeInventory();
                this.guiManager.playerMainInventories.put(player.getUniqueId(), save);
                this.guiManager.guiData.get(player.getUniqueId()).put("currentSlot", index);
                this.guiManager.getPlugin().guiExactChoiceToggler.openNew(player, index);
                event.setCancelled(true);
            } else if (event.getClick() == ClickType.SHIFT_RIGHT) {
                save = this.guiManager.playerMainInventories.get(player.getUniqueId());
                this.guiManager.playerMainInventories.remove(player.getUniqueId());
                player.closeInventory();
                this.guiManager.playerMainInventories.put(player.getUniqueId(), save);
                this.guiManager.guiData.get(player.getUniqueId()).put("currentSlot", index);
                this.guiManager.getPlugin().guiMaterialChoiceToggler.openNew(player, index);
                event.setCancelled(true);
            }
        }
    }

    private SavedRecipe saveIntoNewRecipe(Inventory gui, NamespacedKey key, Map<String, Object> data) {
        ItemStack slotIconItem;
        List<ItemStack> items = Arrays.asList(gui.getItem(10), gui.getItem(11), gui.getItem(12), gui.getItem(19), gui.getItem(20), gui.getItem(21), gui.getItem(28), gui.getItem(29), gui.getItem(30));
        RecipeType type = (RecipeType)((Object)data.get("type"));
        IngredientType[] ingredientTypes = (IngredientType[])data.get("ingredientTypes");
        List materialChoiceExtra = (List)data.get("materialChoiceExtra");
        ItemStack resultItem = gui.getItem(23);
        if (resultItem == null || resultItem.getType() == Material.AIR) {
            resultItem = new ItemStack(Material.GRASS_BLOCK, 1);
        }
        if ((slotIconItem = gui.getItem(16)) == null || slotIconItem.getType() == Material.AIR) {
            slotIconItem = new ItemStack(Material.GRASS_BLOCK, 1);
        }
        if (items.stream().allMatch(item -> item == null || item.getType() == Material.AIR)) {
            items.set(0, new ItemStack(Material.GRASS_BLOCK, 1));
        }
        return new SavedRecipe(key, type, items, resultItem, ingredientTypes, materialChoiceExtra, slotIconItem);
    }

    void fillCraftingSlots(Inventory gui, SavedRecipe recipe, IngredientType[] ingredientTypes, List<List<Material>> materialChoiceExtra) {
        for (int i = 0; i < 9; ++i) {
            this.fillCraftingSlot(i, gui, recipe, ingredientTypes, materialChoiceExtra);
        }
    }

    void fillCraftingSlot(int slot, Inventory gui, SavedRecipe recipe, IngredientType[] ingredientTypes, List<List<Material>> materialChoiceExtra) {
        int[] SLOTS = new int[]{10, 11, 12, 19, 20, 21, 28, 29, 30};
        switch (ingredientTypes[slot]) {
            case NORMAL: 
            case EXACT_CHOICE: {
                gui.setItem(SLOTS[slot], recipe.items().get(slot));
                break;
            }
            case MATERIAL_CHOICE: {
                gui.setItem(SLOTS[slot], Util.renderMaterialChoiceIcon(materialChoiceExtra.get(slot), true));
            }
        }
    }

    private ItemStack getDisplayItemStackForRecipeType(RecipeType type) {
        switch (type) {
            case SHAPED: {
                return Util.createItemStack(Material.CRAFTING_TABLE, 1, "\u00a73Recipe Type", "\u00a7f>> SHAPED", "  \u00a77The required items must be in this shape.", "  \u00a77If the grid is less than 3x3, the empty space is ignored.", "\u00a77>> SHAPELESS", "\u00a77>> STACKED ITEMS", "\u00a77>> STACKED ITEMS (SHAPELESS)", "\u00a7eCLICK \u00a77to toggle");
            }
            case SHAPELESS: {
                return Util.createItemStack(Material.CRAFTING_TABLE, 1, "\u00a73Recipe Type", "\u00a77>> SHAPED", "\u00a7f>> SHAPELESS", "  \u00a77The required items can be in any configuration.", "\u00a77>> STACKED ITEMS", "\u00a77>> STACKED ITEMS (SHAPELESS)", "\u00a7eCLICK \u00a77to toggle");
            }
            case STACKED_ITEMS: {
                return Util.createItemStack(Material.CRAFTING_TABLE, 1, "\u00a73Recipe Type", "\u00a77>> SHAPED", "\u00a77>> SHAPELESS", "\u00a7f>> STACKED ITEMS", "  \u00a77The required items in the grid can be stacked, so rather than", "  \u00a77requiring 9 items, you can require 9 stacks of items.", "  \u00a77(Material choice doesn't work with stacked items.)", "\u00a77>> STACKED ITEMS (SHAPELESS)", "\u00a7eCLICK \u00a77to toggle");
            }
            case STACKED_ITEMS_SHAPELESS: {
                return Util.createItemStack(Material.CRAFTING_TABLE, 1, "\u00a73Recipe Type", "\u00a77>> SHAPED", "\u00a77>> SHAPELESS", "\u00a77>> STACKED ITEMS", "\u00a7f>> STACKED ITEMS (SHAPELESS)", "  \u00a77Shapeless version of stacked items. No specific shape is needed.", "\u00a7eCLICK \u00a77to toggle");
            }
        }
        throw new IllegalArgumentException();
    }
}

