/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatcrafts.events;

import io.github.greatericontop.greatcrafts.GreatCrafts;
import io.github.greatericontop.greatcrafts.internal.Util;
import io.github.greatericontop.greatcrafts.internal.datastructures.IngredientType;
import io.github.greatericontop.greatcrafts.internal.datastructures.RecipeType;
import io.github.greatericontop.greatcrafts.internal.datastructures.SavedRecipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class StackedItemsCraftListener
implements Listener {
    private final GreatCrafts plugin;

    public StackedItemsCraftListener(GreatCrafts plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onCraft(CraftItemEvent event) {
        Recipe _rawRecipe = event.getRecipe();
        if (_rawRecipe instanceof ShapedRecipe) {
            ShapedRecipe _shapedRecipe = (ShapedRecipe)_rawRecipe;
            NamespacedKey recipeKey = _shapedRecipe.getKey();
            SavedRecipe savedRecipe = this.plugin.recipeManager.getRecipe(recipeKey.toString());
            if (savedRecipe == null || savedRecipe.type() != RecipeType.STACKED_ITEMS) {
                return;
            }
            this.processStackedItems(event, savedRecipe, recipeKey);
        } else if (_rawRecipe instanceof ShapelessRecipe) {
            ShapelessRecipe _shapelessRec = (ShapelessRecipe)_rawRecipe;
            NamespacedKey recipeKey = _shapelessRec.getKey();
            SavedRecipe savedRecipe = this.plugin.recipeManager.getRecipe(recipeKey.toString());
            if (savedRecipe == null || savedRecipe.type() != RecipeType.STACKED_ITEMS_SHAPELESS) {
                return;
            }
            this.processShapelessStackedItems(event, savedRecipe, recipeKey);
        }
    }

    private void processStackedItems(CraftItemEvent event, SavedRecipe savedRecipe, NamespacedKey recipeKey) {
        Player player = (Player)event.getWhoClicked();
        event.setCancelled(true);
        int minSlotInSavedRec = StackedItemsCraftListener.getMinSlotInSavedRec(savedRecipe);
        int minSlotInEventInv = Integer.MAX_VALUE;
        for (int i = 1; i <= 9; ++i) {
            if (event.getInventory().getItem(i) == null || event.getInventory().getItem(i).getType() == Material.AIR) continue;
            minSlotInEventInv = Math.min(minSlotInEventInv, i);
        }
        int savedRecToEventInvOffset = minSlotInEventInv - minSlotInSavedRec;
        int maxCraftsAvailable = Integer.MAX_VALUE;
        for (int slotNum = 0; slotNum < 9; ++slotNum) {
            ItemStack requiredItemStack = savedRecipe.items().get(slotNum);
            if (requiredItemStack == null || requiredItemStack.getType() == Material.AIR) continue;
            ItemStack itemStackInGrid = event.getInventory().getItem(slotNum + savedRecToEventInvOffset);
            if (itemStackInGrid == null || itemStackInGrid.getType() != requiredItemStack.getType() || savedRecipe.ingredientTypes()[slotNum] == IngredientType.EXACT_CHOICE && !itemStackInGrid.isSimilar(requiredItemStack)) {
                this.plugin.languager.stackedItemsErrorMissedExactMatch((CommandSender)player, recipeKey.toString());
                return;
            }
            int craftsAvailable = itemStackInGrid.getAmount() / requiredItemStack.getAmount();
            maxCraftsAvailable = Math.min(maxCraftsAvailable, craftsAvailable);
        }
        if (maxCraftsAvailable == 0) {
            this.plugin.languager.stackedItemsErrorNotEnoughItems((CommandSender)player, recipeKey.toString());
            return;
        }
        int actualAmountCrafted = this.processCraft(savedRecipe, player, event, maxCraftsAvailable);
        for (int slotNum = 0; slotNum < 9; ++slotNum) {
            ItemStack requiredItemStack = savedRecipe.items().get(slotNum);
            if (requiredItemStack == null) continue;
            int required = requiredItemStack.getAmount();
            ItemStack stack = event.getInventory().getItem(slotNum + savedRecToEventInvOffset);
            stack.setAmount(stack.getAmount() - required * actualAmountCrafted);
            event.getInventory().setItem(slotNum + savedRecToEventInvOffset, stack);
        }
    }

    public static int getMinSlotInSavedRec(SavedRecipe savedRecipe) {
        int minSlotInSavedRec = Integer.MAX_VALUE;
        for (int i = 0; i < 9; ++i) {
            if (savedRecipe.items().get(i) == null || savedRecipe.items().get(i).getType() == Material.AIR) continue;
            minSlotInSavedRec = Math.min(minSlotInSavedRec, i);
        }
        return minSlotInSavedRec;
    }

    private void processShapelessStackedItems(CraftItemEvent event, SavedRecipe savedRecipe, NamespacedKey recipeKey) {
        Player player = (Player)event.getWhoClicked();
        event.setCancelled(true);
        ArrayList<ItemStack> requiredItems = new ArrayList<ItemStack>(savedRecipe.items());
        ArrayList<ItemStack> inventorySlotItems = new ArrayList<ItemStack>();
        for (int i = 1; i <= 9; ++i) {
            inventorySlotItems.add(event.getInventory().getItem(i));
        }
        int[] requiredItemsSlotMapping = new int[9];
        int maxCraftsAvailable = Integer.MAX_VALUE;
        requiredItems.removeIf(item -> item == null || item.getType() == Material.AIR);
        requiredItems.sort((a, b) -> Integer.compare(b.getAmount(), a.getAmount()));
        int reqIndex = 0;
        while (reqIndex < requiredItems.size()) {
            ItemStack reqItemStack = (ItemStack)requiredItems.get(reqIndex);
            int highestCountSoFar = 0;
            int highestCountSlot = -1;
            for (int slotNum = 0; slotNum < 9; ++slotNum) {
                ItemStack inventorySlotItem = (ItemStack)inventorySlotItems.get(slotNum);
                if (inventorySlotItem == null || inventorySlotItem.getType() != reqItemStack.getType() || highestCountSoFar >= inventorySlotItem.getAmount()) continue;
                highestCountSoFar = inventorySlotItem.getAmount();
                highestCountSlot = slotNum;
            }
            inventorySlotItems.set(highestCountSlot, null);
            int craftsPossibleHere = highestCountSoFar / reqItemStack.getAmount();
            maxCraftsAvailable = Math.min(maxCraftsAvailable, craftsPossibleHere);
            requiredItemsSlotMapping[highestCountSlot] = reqIndex++;
        }
        if (maxCraftsAvailable == 0) {
            this.plugin.languager.stackedItemsErrorNotEnoughItems((CommandSender)player, recipeKey.toString());
            return;
        }
        int actualAmountCrafted = this.processCraft(savedRecipe, player, event, maxCraftsAvailable);
        for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
            int slotIndexInInvSetItem = slotIndex + 1;
            ItemStack stack = event.getInventory().getItem(slotIndexInInvSetItem);
            if (stack == null || stack.getType() == Material.AIR) continue;
            int amountToRemove = ((ItemStack)requiredItems.get(requiredItemsSlotMapping[slotIndex])).getAmount() * actualAmountCrafted;
            stack.setAmount(stack.getAmount() - amountToRemove);
            event.getInventory().setItem(slotIndexInInvSetItem, stack);
        }
    }

    private int processCraft(SavedRecipe savedRecipe, Player player, CraftItemEvent event, int maxCraftsAvailable) {
        int actualAmountCrafted;
        String recKey = savedRecipe.key().toString();
        if (this.plugin.recipeCraftingLimits.containsKey(recKey)) {
            int limit;
            Map<String, Integer> playerCraftsMap;
            int craftsMadePreviously;
            if (!this.plugin.playerCraftCounts.containsKey(player.getUniqueId())) {
                this.plugin.playerCraftCounts.put(player.getUniqueId(), new HashMap());
            }
            if ((craftsMadePreviously = (playerCraftsMap = this.plugin.playerCraftCounts.get(player.getUniqueId())).getOrDefault(recKey, 0).intValue()) >= (limit = this.plugin.recipeCraftingLimits.get(recKey).intValue())) {
                this.plugin.languager.craftingLimitFailure((CommandSender)player, limit);
                return 0;
            }
            if (craftsMadePreviously + maxCraftsAvailable > limit) {
                maxCraftsAvailable = limit - craftsMadePreviously;
            }
        }
        ItemStack result = savedRecipe.result().clone();
        if (event.getClick() == ClickType.SHIFT_LEFT || event.getClick() == ClickType.SHIFT_RIGHT) {
            actualAmountCrafted = Util.performShiftClickCraft(player, result, maxCraftsAvailable);
        } else if (player.getItemOnCursor() == null || player.getItemOnCursor().getType() == Material.AIR) {
            actualAmountCrafted = 1;
            player.setItemOnCursor(result);
        } else if (player.getItemOnCursor().isSimilar(result) && player.getItemOnCursor().getAmount() + result.getAmount() <= result.getMaxStackSize()) {
            actualAmountCrafted = 1;
            player.getItemOnCursor().setAmount(result.getAmount() + player.getItemOnCursor().getAmount());
        } else {
            return 0;
        }
        if (this.plugin.recipeCraftingLimits.containsKey(recKey) && actualAmountCrafted > 0) {
            Map<String, Integer> playerCraftsMap = this.plugin.playerCraftCounts.get(player.getUniqueId());
            int craftsMadePreviously = playerCraftsMap.getOrDefault(recKey, 0);
            int limit = this.plugin.recipeCraftingLimits.get(recKey);
            playerCraftsMap.put(recKey, craftsMadePreviously + actualAmountCrafted);
            this.plugin.languager.craftingLimitNotification((CommandSender)player, craftsMadePreviously + actualAmountCrafted, limit);
        }
        return actualAmountCrafted;
    }
}

