/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatcrafts.events;

import io.github.greatericontop.greatcrafts.GreatCrafts;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class PermissionRestrictionListener
implements Listener {
    private final GreatCrafts plugin;

    public PermissionRestrictionListener(GreatCrafts plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onCraftPermissionCheck(CraftItemEvent event) {
        String stringKey;
        Recipe rawRecipe = event.getRecipe();
        if (rawRecipe instanceof ShapedRecipe) {
            ShapedRecipe rawRecipeShaped = (ShapedRecipe)rawRecipe;
            stringKey = rawRecipeShaped.getKey().toString();
        } else if (rawRecipe instanceof ShapelessRecipe) {
            ShapelessRecipe rawRecipeShapeless = (ShapelessRecipe)rawRecipe;
            stringKey = rawRecipeShapeless.getKey().toString();
        } else {
            return;
        }
        if (!this.plugin.recipeManager.isRecipeCustom(stringKey)) {
            return;
        }
        String permissionReq = this.plugin.recipePermissionRequirements.get(stringKey);
        if (permissionReq == null) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!player.hasPermission(permissionReq)) {
            event.setCancelled(true);
            this.plugin.languager.playerCraftNoPermissionError((CommandSender)player, stringKey, permissionReq);
        }
    }
}

