/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatcrafts.events;

import io.github.greatericontop.greatcrafts.GreatCrafts;
import io.github.greatericontop.greatcrafts.events.StackedItemsCraftListener;
import io.github.greatericontop.greatcrafts.internal.datastructures.IngredientType;
import io.github.greatericontop.greatcrafts.internal.datastructures.RecipeType;
import io.github.greatericontop.greatcrafts.internal.datastructures.SavedRecipe;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Crafter;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.CrafterCraftEvent;
import org.bukkit.inventory.CraftingRecipe;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class CrafterEvents
implements Listener {
    private final GreatCrafts plugin;

    public CrafterEvents(GreatCrafts plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCrafterCraft(CrafterCraftEvent event) {
        CraftingRecipe _rawRecipe = event.getRecipe();
        if (_rawRecipe instanceof ShapedRecipe) {
            ShapedRecipe _shapedRecipe = (ShapedRecipe)_rawRecipe;
            NamespacedKey recipeKey = _shapedRecipe.getKey();
            SavedRecipe savedRecipe = this.plugin.recipeManager.getRecipe(recipeKey.toString());
            if (savedRecipe != null && this.plugin.recipePermissionRequirements.get(recipeKey.toString()) != null) {
                this.messageNearbyPlayersPermission(event);
                event.setCancelled(true);
                return;
            }
            if (savedRecipe == null || savedRecipe.type() != RecipeType.STACKED_ITEMS) {
                return;
            }
            this.processCrafterShapedStackedItems(event, savedRecipe, recipeKey);
        } else if (_rawRecipe instanceof ShapelessRecipe) {
            ShapelessRecipe _shapelessRec = (ShapelessRecipe)_rawRecipe;
            NamespacedKey recipeKey = _shapelessRec.getKey();
            SavedRecipe savedRecipe = this.plugin.recipeManager.getRecipe(recipeKey.toString());
            if (savedRecipe != null && this.plugin.recipePermissionRequirements.get(recipeKey.toString()) != null) {
                this.messageNearbyPlayersPermission(event);
                event.setCancelled(true);
                return;
            }
            if (savedRecipe == null || savedRecipe.type() != RecipeType.STACKED_ITEMS_SHAPELESS) {
                return;
            }
            this.processCrafterShapelessStackedItems(event, savedRecipe, recipeKey);
        }
    }

    private void processCrafterShapedStackedItems(CrafterCraftEvent event, SavedRecipe savedRecipe, NamespacedKey recipeKey) {
        ItemStack requiredItemStack;
        int slotNum;
        event.setCancelled(true);
        Crafter blockState = (Crafter)event.getBlock().getState();
        Inventory eventInv = blockState.getInventory();
        int minSlotInSavedRec = StackedItemsCraftListener.getMinSlotInSavedRec(savedRecipe);
        int minSlotInEventInv = Integer.MAX_VALUE;
        for (int i = 0; i <= 8; ++i) {
            if (eventInv.getItem(i) == null || eventInv.getItem(i).getType() == Material.AIR) continue;
            minSlotInEventInv = Math.min(minSlotInEventInv, i);
        }
        int savedRecToEventInvOffset = minSlotInEventInv - minSlotInSavedRec;
        for (slotNum = 0; slotNum < 9; ++slotNum) {
            requiredItemStack = savedRecipe.items().get(slotNum);
            if (requiredItemStack == null || requiredItemStack.getType() == Material.AIR) continue;
            ItemStack itemStackInGrid = eventInv.getItem(slotNum + savedRecToEventInvOffset);
            if (itemStackInGrid == null || itemStackInGrid.getType() != requiredItemStack.getType() || savedRecipe.ingredientTypes()[slotNum] == IngredientType.EXACT_CHOICE && !itemStackInGrid.isSimilar(requiredItemStack)) {
                this.messageNearbyPlayers(event, recipeKey.toString());
                return;
            }
            if (itemStackInGrid.getAmount() >= requiredItemStack.getAmount()) continue;
            return;
        }
        for (slotNum = 0; slotNum < 9; ++slotNum) {
            requiredItemStack = savedRecipe.items().get(slotNum);
            if (requiredItemStack == null) continue;
            int required = requiredItemStack.getAmount();
            ItemStack stack = eventInv.getItem(slotNum + savedRecToEventInvOffset);
            stack.setAmount(stack.getAmount() - required + 1);
            eventInv.setItem(slotNum + savedRecToEventInvOffset, stack);
        }
        event.setCancelled(false);
    }

    private void processCrafterShapelessStackedItems(CrafterCraftEvent event, SavedRecipe savedRecipe, NamespacedKey recipeKey) {
        Crafter blockState = (Crafter)event.getBlock().getState();
        Inventory eventInv = blockState.getInventory();
        event.setCancelled(true);
        ArrayList<ItemStack> requiredItems = new ArrayList<ItemStack>(savedRecipe.items());
        ArrayList<ItemStack> inventorySlotItems = new ArrayList<ItemStack>();
        for (int i = 0; i <= 8; ++i) {
            inventorySlotItems.add(eventInv.getItem(i));
        }
        int[] requiredItemsSlotMapping = new int[9];
        requiredItems.removeIf(item -> item == null || item.getType() == Material.AIR);
        requiredItems.sort((a, b) -> Integer.compare(b.getAmount(), a.getAmount()));
        int reqIndex = 0;
        while (reqIndex < requiredItems.size()) {
            ItemStack reqItemStack = (ItemStack)requiredItems.get(reqIndex);
            int highestCountSoFar = 0;
            int highestCountSlot = -1;
            for (int slotNum = 0; slotNum < 9; ++slotNum) {
                ItemStack inventorySlotItem = (ItemStack)inventorySlotItems.get(slotNum);
                if (inventorySlotItem == null || inventorySlotItem.getType() != reqItemStack.getType() || highestCountSoFar >= inventorySlotItem.getAmount()) continue;
                highestCountSoFar = inventorySlotItem.getAmount();
                highestCountSlot = slotNum;
            }
            if (highestCountSoFar < reqItemStack.getAmount()) {
                return;
            }
            inventorySlotItems.set(highestCountSlot, null);
            requiredItemsSlotMapping[highestCountSlot] = reqIndex++;
        }
        for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
            ItemStack stack = eventInv.getItem(slotIndex);
            if (stack == null || stack.getType() == Material.AIR) continue;
            int amountToRemove = ((ItemStack)requiredItems.get(requiredItemsSlotMapping[slotIndex])).getAmount() - 1;
            stack.setAmount(stack.getAmount() - amountToRemove);
            eventInv.setItem(slotIndex, stack);
        }
        event.setCancelled(false);
    }

    private void messageNearbyPlayers(CrafterCraftEvent event, String recipeKey) {
        for (Entity e : event.getBlock().getWorld().getNearbyEntities(event.getBlock().getLocation(), 20.0, 20.0, 20.0, entity -> entity instanceof Player)) {
            this.plugin.languager.stackedItemsErrorMissedExactMatch((CommandSender)e, recipeKey);
        }
    }

    private void messageNearbyPlayersPermission(CrafterCraftEvent event) {
        for (Entity e : event.getBlock().getWorld().getNearbyEntities(event.getBlock().getLocation(), 20.0, 20.0, 20.0, entity -> entity instanceof Player)) {
            this.plugin.languager.crafterCraftNoPermissionError((CommandSender)e);
        }
    }
}

