/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatcrafts.events;

import io.github.greatericontop.greatcrafts.GreatCrafts;
import io.github.greatericontop.greatcrafts.internal.datastructures.AutoUnlockSetting;
import io.github.greatericontop.greatcrafts.internal.datastructures.IngredientType;
import io.github.greatericontop.greatcrafts.internal.datastructures.SavedRecipe;
import java.util.ArrayList;
import java.util.Iterator;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.inventory.ItemStack;

public class AutoUnlockListener
implements Listener {
    private final GreatCrafts plugin;

    public AutoUnlockListener(GreatCrafts plugin) {
        this.plugin = plugin;
    }

    private boolean playerHasPermission(Player player, SavedRecipe rec) {
        String permission = this.plugin.recipePermissionRequirements.get(rec.key().toString());
        if (permission == null) {
            return true;
        }
        return player.hasPermission(permission);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        int counter = 0;
        for (SavedRecipe rec : this.plugin.recipeManager.getAllSavedRecipes()) {
            AutoUnlockSetting setting = this.plugin.autoUnlockExceptions.getOrDefault(rec.key().toString(), this.plugin.autoUnlockSetting);
            if (setting != AutoUnlockSetting.ALWAYS || !this.playerHasPermission(player, rec) || !player.discoverRecipe(rec.key())) continue;
            ++counter;
        }
        if (counter > 0) {
            this.plugin.languager.notifyAutoUnlockOnJoin((CommandSender)player, counter);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler
    public void onItemPickup(PlayerPickupItemEvent event) {
        Player player = event.getPlayer();
        ItemStack pickedUpItem = event.getItem().getItemStack();
        Iterator<SavedRecipe> iterator = this.plugin.recipeManager.getAllSavedRecipes().iterator();
        while (true) {
            boolean hasAtLeastOne;
            SavedRecipe rec;
            block22: {
                ArrayList<ItemStack> invContents;
                boolean shouldUnlockEach;
                block21: {
                    AutoUnlockSetting setting;
                    block20: {
                        if (!iterator.hasNext()) {
                            return;
                        }
                        rec = iterator.next();
                        if (player.hasDiscoveredRecipe(rec.key()) || !this.playerHasPermission(player, rec)) continue;
                        setting = this.plugin.autoUnlockExceptions.getOrDefault(rec.key().toString(), this.plugin.autoUnlockSetting);
                        if (this.plugin.autoUnlockSetting != AutoUnlockSetting.EACH) break block20;
                        shouldUnlockEach = true;
                        invContents = new ArrayList<ItemStack>(60);
                        for (ItemStack invItem : player.getInventory().getContents()) {
                            if (invItem == null) continue;
                            invContents.add(invItem);
                        }
                        invContents.add(pickedUpItem);
                        break block21;
                    }
                    if (setting != AutoUnlockSetting.ONE) continue;
                    hasAtLeastOne = false;
                    break block22;
                }
                block12: for (int slot = 0; slot < 9; ++slot) {
                    IngredientType type = rec.ingredientTypes()[slot];
                    switch (type) {
                        case NORMAL: {
                            ItemStack requiredItem = rec.items().get(slot);
                            if (requiredItem == null || requiredItem.getType() == Material.AIR) break;
                            boolean matched = false;
                            for (ItemStack invItem : invContents) {
                                if (invItem == null || invItem.getType() != requiredItem.getType()) continue;
                                matched = true;
                                break;
                            }
                            if (matched) break;
                            shouldUnlockEach = false;
                            break block12;
                        }
                        case EXACT_CHOICE: {
                            ItemStack requiredItem = rec.items().get(slot);
                            if (requiredItem == null || requiredItem.getType() == Material.AIR) break;
                            boolean matched = false;
                            for (ItemStack invItem : invContents) {
                                if (invItem == null || !invItem.isSimilar(requiredItem)) continue;
                                matched = true;
                                break;
                            }
                            if (matched) break;
                            shouldUnlockEach = false;
                            break block12;
                        }
                        case MATERIAL_CHOICE: {
                            boolean matched = false;
                            block15: for (Material requiredMat : rec.materialChoiceExtra().get(slot)) {
                                for (ItemStack invItem : invContents) {
                                    if (invItem == null || invItem.getType() != requiredMat) continue;
                                    matched = true;
                                    break block15;
                                }
                            }
                            if (matched) break;
                            shouldUnlockEach = false;
                            break block12;
                        }
                    }
                }
                if (!shouldUnlockEach) continue;
                player.discoverRecipe(rec.key());
                this.plugin.languager.notifyAutoUnlockEach((CommandSender)player);
                continue;
            }
            block17: for (int slot = 0; slot < 9; ++slot) {
                IngredientType type = rec.ingredientTypes()[slot];
                switch (type) {
                    case NORMAL: {
                        ItemStack requiredItem = rec.items().get(slot);
                        if (requiredItem == null || requiredItem.getType() != pickedUpItem.getType()) break;
                        hasAtLeastOne = true;
                        break block17;
                    }
                    case EXACT_CHOICE: {
                        ItemStack requiredItem = rec.items().get(slot);
                        if (requiredItem == null || !requiredItem.isSimilar(pickedUpItem)) break;
                        hasAtLeastOne = true;
                        break block17;
                    }
                    case MATERIAL_CHOICE: {
                        for (Material requiredMat : rec.materialChoiceExtra().get(slot)) {
                            if (requiredMat != pickedUpItem.getType()) continue;
                            hasAtLeastOne = true;
                            break block17;
                        }
                    }
                }
            }
            if (!hasAtLeastOne) continue;
            player.discoverRecipe(rec.key());
            this.plugin.languager.notifyAutoUnlockOne((CommandSender)player);
        }
    }
}

