/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatcrafts.commands.tabcompleters;

import io.github.greatericontop.greatcrafts.GreatCrafts;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.util.StringUtil;

public class GCUtilTabCompleter
implements TabCompleter {
    private List<String> enchantments = new ArrayList<String>();
    private GreatCrafts plugin;

    public GCUtilTabCompleter(GreatCrafts plugin) {
        this.plugin = plugin;
        for (Enchantment enchantment : Enchantment.values()) {
            this.enchantments.add(enchantment.getKey().getKey());
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1) {
            List<String> completions = List.of("setcustomname", "setloreline", "deletelorelines", "enchant", "duplicaterecipe", "resetlimits");
            return (List)StringUtil.copyPartialMatches((String)args[0], completions, new ArrayList(completions.size()));
        }
        if (args[0].equalsIgnoreCase("setcustomname")) {
            return List.of("<name...>");
        }
        if (args[0].equalsIgnoreCase("setloreline")) {
            if (args.length == 2) {
                return List.of("<line #>");
            }
            return List.of("[<lore line...>]");
        }
        if (args[0].equalsIgnoreCase("deletelorelines")) {
            if (args.length == 2) {
                return List.of("<line #>");
            }
            return List.of("[<line #>]");
        }
        if (args[0].equalsIgnoreCase("enchant")) {
            if (args.length == 2) {
                return (List)StringUtil.copyPartialMatches((String)args[1], this.enchantments, new ArrayList(this.enchantments.size()));
            }
            if (args.length == 3) {
                return List.of("<level>");
            }
        }
        if (args[0].equalsIgnoreCase("duplicaterecipe")) {
            if (args.length == 2) {
                Set keys = this.plugin.recipes.getKeys(false);
                return (List)StringUtil.copyPartialMatches((String)args[1], (Iterable)keys, new ArrayList(keys.size()));
            }
            if (args.length == 3) {
                return List.of("<target namespace:name>");
            }
        }
        if (args[0].equalsIgnoreCase("resetlimits") && args.length == 2) {
            return List.of("[<player name>]");
        }
        return null;
    }
}

