/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatcrafts.commands;

import io.github.greatericontop.greatcrafts.GreatCrafts;
import io.github.greatericontop.greatcrafts.internal.RecipeLoader;
import io.github.greatericontop.greatcrafts.internal.datastructures.SavedRecipe;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class ReloadRecipesCommand
implements CommandExecutor {
    private final GreatCrafts plugin;

    public ReloadRecipesCommand(GreatCrafts plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        List<SavedRecipe> recipes = this.plugin.recipeManager.getAllSavedRecipes();
        for (SavedRecipe savedRecipe : recipes) {
            Bukkit.removeRecipe((NamespacedKey)savedRecipe.key());
            RecipeLoader.compileAndAddRecipe(savedRecipe, sender);
        }
        sender.sendMessage(String.format("\u00a73Successfully reloaded %s recipes.", recipes.size()));
        sender.sendMessage("\u00a7eNote: \u00a73Players still need to reconnect to see the recipe client-side, but it will work on the server.");
        return true;
    }
}

