/*
 * Decompiled with CFR 0.152.
 */
package io.github.greatericontop.greatcrafts.commands;

import java.util.Arrays;
import javax.annotation.Nullable;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;

public class GreatCommands {
    @Nullable
    public static String argumentString(int i, String[] args) {
        if (args.length <= i) {
            return null;
        }
        return args[i];
    }

    @Nullable
    public static String argumentStringFromChoices(int i, String[] args, String[] choices) {
        if (args.length <= i) {
            return null;
        }
        for (String choice : choices) {
            if (!args[i].equals(choice)) continue;
            return choice;
        }
        return null;
    }

    @Nullable
    public static String argumentStringConsumeRest(int iStart, String[] args) {
        if (args.length <= iStart) {
            return null;
        }
        return String.join((CharSequence)" ", Arrays.copyOfRange(args, iStart, args.length));
    }

    @Nullable
    public static Integer argumentInteger(int i, String[] args) {
        if (args.length <= i) {
            return null;
        }
        try {
            return Integer.parseInt(args[i]);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static int[] argumentIntegerConsumeRest(int iStart, String[] args) {
        if (args.length <= iStart) {
            return null;
        }
        int[] result = new int[args.length - iStart];
        for (int argIndex = iStart; argIndex < args.length; ++argIndex) {
            try {
                result[argIndex - iStart] = Integer.parseInt(args[argIndex]);
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return result;
    }

    @Nullable
    public static Enchantment argumentMinecraftEnchantment(int i, String[] args) {
        if (args.length <= i) {
            return null;
        }
        try {
            return Enchantment.getByKey((NamespacedKey)new NamespacedKey("minecraft", args[i]));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

